/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.model.entity;

import com.dianping.cat.status.model.BaseEntity;
import com.dianping.cat.status.model.IVisitor;
import com.dianping.cat.status.model.entity.CustomInfo;
import com.dianping.cat.status.model.entity.DiskInfo;
import com.dianping.cat.status.model.entity.Extension;
import com.dianping.cat.status.model.entity.MemoryInfo;
import com.dianping.cat.status.model.entity.MessageInfo;
import com.dianping.cat.status.model.entity.OsInfo;
import com.dianping.cat.status.model.entity.RuntimeInfo;
import com.dianping.cat.status.model.entity.ThreadsInfo;
import com.dianping.cat.status.model.transform.DefaultXmlBuilder;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class StatusInfo
extends BaseEntity<StatusInfo> {
    private Date timestamp;
    private RuntimeInfo runtime;
    private OsInfo os;
    private DiskInfo disk;
    private MemoryInfo memory;
    private ThreadsInfo thread;
    private MessageInfo message;
    private final Map<String, Extension> extensions = new LinkedHashMap<String, Extension>();
    private final Map<String, CustomInfo> customInfos = new LinkedHashMap<String, CustomInfo>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitStatus(this);
    }

    public StatusInfo addCustomInfo(CustomInfo customInfo) {
        this.customInfos.put(customInfo.getKey(), customInfo);
        return this;
    }

    public StatusInfo addExtension(Extension extension) {
        this.extensions.put(extension.getId(), extension);
        return this;
    }

    public CustomInfo findCustomInfo(String key) {
        return this.customInfos.get(key);
    }

    public Extension findExtension(String id) {
        return this.extensions.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomInfo findOrCreateCustomInfo(String key) {
        CustomInfo customInfo = this.customInfos.get(key);
        if (customInfo == null) {
            Map<String, CustomInfo> map = this.customInfos;
            synchronized (map) {
                customInfo = this.customInfos.get(key);
                if (customInfo == null) {
                    customInfo = new CustomInfo(key);
                    this.customInfos.put(key, customInfo);
                }
            }
        }
        return customInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extension findOrCreateExtension(String id) {
        Extension extension = this.extensions.get(id);
        if (extension == null) {
            Map<String, Extension> map = this.extensions;
            synchronized (map) {
                extension = this.extensions.get(id);
                if (extension == null) {
                    extension = new Extension(id);
                    this.extensions.put(id, extension);
                }
            }
        }
        return extension;
    }

    @Override
    public void mergeAttributes(StatusInfo other) {
        if (other.getTimestamp() != null) {
            this.timestamp = other.getTimestamp();
        }
    }

    public boolean removeCustomInfo(String key) {
        if (this.customInfos.containsKey(key)) {
            this.customInfos.remove(key);
            return true;
        }
        return false;
    }

    public boolean removeExtension(String id) {
        if (this.extensions.containsKey(id)) {
            this.extensions.remove(id);
            return true;
        }
        return false;
    }

    public StatusInfo setDisk(DiskInfo disk) {
        this.disk = disk;
        return this;
    }

    public StatusInfo setMemory(MemoryInfo memory) {
        this.memory = memory;
        return this;
    }

    public StatusInfo setMessage(MessageInfo message) {
        this.message = message;
        return this;
    }

    public StatusInfo setOs(OsInfo os) {
        this.os = os;
        return this;
    }

    public StatusInfo setRuntime(RuntimeInfo runtime) {
        this.runtime = runtime;
        return this;
    }

    public StatusInfo setThread(ThreadsInfo thread) {
        this.thread = thread;
        return this;
    }

    public StatusInfo setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Override
    public String toString() {
        return new DefaultXmlBuilder().buildXml(this);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public RuntimeInfo getRuntime() {
        return this.runtime;
    }

    public OsInfo getOs() {
        return this.os;
    }

    public DiskInfo getDisk() {
        return this.disk;
    }

    public MemoryInfo getMemory() {
        return this.memory;
    }

    public ThreadsInfo getThread() {
        return this.thread;
    }

    public MessageInfo getMessage() {
        return this.message;
    }

    public Map<String, Extension> getExtensions() {
        return this.extensions;
    }

    public Map<String, CustomInfo> getCustomInfos() {
        return this.customInfos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusInfo)) {
            return false;
        }
        StatusInfo other = (StatusInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        RuntimeInfo this$runtime = this.getRuntime();
        RuntimeInfo other$runtime = other.getRuntime();
        if (this$runtime == null ? other$runtime != null : !((Object)this$runtime).equals(other$runtime)) {
            return false;
        }
        OsInfo this$os = this.getOs();
        OsInfo other$os = other.getOs();
        if (this$os == null ? other$os != null : !((Object)this$os).equals(other$os)) {
            return false;
        }
        DiskInfo this$disk = this.getDisk();
        DiskInfo other$disk = other.getDisk();
        if (this$disk == null ? other$disk != null : !((Object)this$disk).equals(other$disk)) {
            return false;
        }
        MemoryInfo this$memory = this.getMemory();
        MemoryInfo other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
            return false;
        }
        ThreadsInfo this$thread = this.getThread();
        ThreadsInfo other$thread = other.getThread();
        if (this$thread == null ? other$thread != null : !((Object)this$thread).equals(other$thread)) {
            return false;
        }
        MessageInfo this$message = this.getMessage();
        MessageInfo other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        Map<String, Extension> this$extensions = this.getExtensions();
        Map<String, Extension> other$extensions = other.getExtensions();
        if (this$extensions == null ? other$extensions != null : !((Object)this$extensions).equals(other$extensions)) {
            return false;
        }
        Map<String, CustomInfo> this$customInfos = this.getCustomInfos();
        Map<String, CustomInfo> other$customInfos = other.getCustomInfos();
        return !(this$customInfos == null ? other$customInfos != null : !((Object)this$customInfos).equals(other$customInfos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StatusInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        RuntimeInfo $runtime = this.getRuntime();
        result = result * 59 + ($runtime == null ? 43 : ((Object)$runtime).hashCode());
        OsInfo $os = this.getOs();
        result = result * 59 + ($os == null ? 43 : ((Object)$os).hashCode());
        DiskInfo $disk = this.getDisk();
        result = result * 59 + ($disk == null ? 43 : ((Object)$disk).hashCode());
        MemoryInfo $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
        ThreadsInfo $thread = this.getThread();
        result = result * 59 + ($thread == null ? 43 : ((Object)$thread).hashCode());
        MessageInfo $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        Map<String, Extension> $extensions = this.getExtensions();
        result = result * 59 + ($extensions == null ? 43 : ((Object)$extensions).hashCode());
        Map<String, CustomInfo> $customInfos = this.getCustomInfos();
        result = result * 59 + ($customInfos == null ? 43 : ((Object)$customInfos).hashCode());
        return result;
    }
}

