/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.model.transform;

import com.dianping.cat.status.model.entity.CustomInfo;
import com.dianping.cat.status.model.entity.DiskInfo;
import com.dianping.cat.status.model.entity.DiskVolumeInfo;
import com.dianping.cat.status.model.entity.Extension;
import com.dianping.cat.status.model.entity.ExtensionDetail;
import com.dianping.cat.status.model.entity.GcInfo;
import com.dianping.cat.status.model.entity.MemoryInfo;
import com.dianping.cat.status.model.entity.MessageInfo;
import com.dianping.cat.status.model.entity.OsInfo;
import com.dianping.cat.status.model.entity.RuntimeInfo;
import com.dianping.cat.status.model.entity.StatusInfo;
import com.dianping.cat.status.model.entity.ThreadsInfo;
import com.dianping.cat.status.model.transform.ILinker;
import java.util.ArrayList;
import java.util.List;

public class DefaultLinker
implements ILinker {
    private boolean deferrable;
    private List<Runnable> deferedJobs = new ArrayList<Runnable>();

    public DefaultLinker(boolean deferrable) {
        this.deferrable = deferrable;
    }

    public void finish() {
        for (Runnable job : this.deferedJobs) {
            job.run();
        }
    }

    @Override
    public boolean onCustomInfo(final StatusInfo parent, final CustomInfo customInfo) {
        if (this.deferrable) {
            this.deferedJobs.add(new Runnable(){

                @Override
                public void run() {
                    parent.addCustomInfo(customInfo);
                }
            });
        } else {
            parent.addCustomInfo(customInfo);
        }
        return true;
    }

    @Override
    public boolean onDisk(StatusInfo parent, DiskInfo disk) {
        parent.setDisk(disk);
        return true;
    }

    @Override
    public boolean onDiskVolume(DiskInfo parent, DiskVolumeInfo diskVolume) {
        parent.addDiskVolume(diskVolume);
        return true;
    }

    @Override
    public boolean onExtension(final StatusInfo parent, final Extension extension) {
        if (this.deferrable) {
            this.deferedJobs.add(new Runnable(){

                @Override
                public void run() {
                    parent.addExtension(extension);
                }
            });
        } else {
            parent.addExtension(extension);
        }
        return true;
    }

    @Override
    public boolean onExtensionDetail(final Extension parent, final ExtensionDetail extensionDetail) {
        if (this.deferrable) {
            this.deferedJobs.add(new Runnable(){

                @Override
                public void run() {
                    parent.addExtensionDetail(extensionDetail);
                }
            });
        } else {
            parent.addExtensionDetail(extensionDetail);
        }
        return true;
    }

    @Override
    public boolean onGc(MemoryInfo parent, GcInfo gc) {
        parent.addGc(gc);
        return true;
    }

    @Override
    public boolean onMemory(StatusInfo parent, MemoryInfo memory) {
        parent.setMemory(memory);
        return true;
    }

    @Override
    public boolean onMessage(StatusInfo parent, MessageInfo message) {
        parent.setMessage(message);
        return true;
    }

    @Override
    public boolean onOs(StatusInfo parent, OsInfo os) {
        parent.setOs(os);
        return true;
    }

    @Override
    public boolean onRuntime(StatusInfo parent, RuntimeInfo runtime) {
        parent.setRuntime(runtime);
        return true;
    }

    @Override
    public boolean onThread(StatusInfo parent, ThreadsInfo thread) {
        parent.setThread(thread);
        return true;
    }
}

