/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status.model.transform;

import com.dianping.cat.status.model.IEntity;
import com.dianping.cat.status.model.entity.CustomInfo;
import com.dianping.cat.status.model.entity.DiskInfo;
import com.dianping.cat.status.model.entity.DiskVolumeInfo;
import com.dianping.cat.status.model.entity.Extension;
import com.dianping.cat.status.model.entity.ExtensionDetail;
import com.dianping.cat.status.model.entity.GcInfo;
import com.dianping.cat.status.model.entity.MemoryInfo;
import com.dianping.cat.status.model.entity.MessageInfo;
import com.dianping.cat.status.model.entity.OsInfo;
import com.dianping.cat.status.model.entity.RuntimeInfo;
import com.dianping.cat.status.model.entity.StatusInfo;
import com.dianping.cat.status.model.entity.ThreadsInfo;
import com.dianping.cat.status.model.transform.DefaultLinker;
import com.dianping.cat.status.model.transform.DefaultSaxMaker;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultSaxParser
extends DefaultHandler {
    private DefaultLinker linker = new DefaultLinker(true);
    private DefaultSaxMaker maker = new DefaultSaxMaker();
    private Stack<String> tags = new Stack();
    private Stack<Object> objects = new Stack();
    private IEntity<?> entity;
    private StringBuilder text = new StringBuilder();

    public static StatusInfo parse(InputSource is) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(StatusInfo.class, is);
    }

    public static StatusInfo parse(InputStream in) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(in));
    }

    public static StatusInfo parse(Reader reader) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(reader));
    }

    public static StatusInfo parse(String xml) throws SAXException, IOException {
        return DefaultSaxParser.parse(new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, String xml) throws SAXException, IOException {
        return DefaultSaxParser.parseEntity(type, new InputSource(new StringReader(xml)));
    }

    public static <T extends IEntity<?>> T parseEntity(Class<T> type, InputSource is) throws SAXException, IOException {
        try {
            DefaultSaxParser handler = new DefaultSaxParser();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/validation", false);
            factory.newSAXParser().parse(is, (DefaultHandler)handler);
            return (T)handler.getEntity();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unable to get SAX parser instance!", e);
        }
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.text.append(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.linker.finish();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.length() == 0) {
            Object currentObj = this.objects.pop();
            String currentTag = this.tags.pop();
            if (currentObj instanceof RuntimeInfo) {
                RuntimeInfo runtime = (RuntimeInfo)currentObj;
                if ("user-dir".equals(currentTag)) {
                    runtime.setUserDir(this.getText());
                } else if ("java-classpath".equals(currentTag)) {
                    runtime.setJavaClasspath(this.getText());
                }
            } else if (currentObj instanceof ThreadsInfo) {
                ThreadsInfo thread = (ThreadsInfo)currentObj;
                if ("dump".equals(currentTag)) {
                    thread.setDump(this.getText());
                }
            } else if (currentObj instanceof Extension) {
                Extension extension = (Extension)currentObj;
                if ("description".equals(currentTag)) {
                    extension.setDescription(this.getText());
                }
            }
        }
        this.text.setLength(0);
    }

    private IEntity<?> getEntity() {
        return this.entity;
    }

    protected String getText() {
        return this.text.toString();
    }

    private void parseForCustomInfo(CustomInfo parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.objects.push(parentObj);
        this.tags.push(qName);
    }

    private void parseForDisk(DiskInfo parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"disk-volume".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under disk!", qName));
        }
        DiskVolumeInfo diskVolume = this.maker.buildDiskVolume(attributes);
        this.linker.onDiskVolume(parentObj, diskVolume);
        this.objects.push(diskVolume);
        this.tags.push(qName);
    }

    private void parseForDiskVolume(DiskVolumeInfo parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.objects.push(parentObj);
        this.tags.push(qName);
    }

    private void parseForExtension(Extension parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("description".equals(qName)) {
            this.objects.push(parentObj);
        } else if ("extensionDetail".equals(qName)) {
            ExtensionDetail extensionDetail = this.maker.buildExtensionDetail(attributes);
            this.linker.onExtensionDetail(parentObj, extensionDetail);
            this.objects.push(extensionDetail);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under extension!", qName));
        }
        this.tags.push(qName);
    }

    private void parseForExtensionDetail(ExtensionDetail parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.objects.push(parentObj);
        this.tags.push(qName);
    }

    private void parseForGc(GcInfo parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.objects.push(parentObj);
        this.tags.push(qName);
    }

    private void parseForMemory(MemoryInfo parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"gc".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under memory!", qName));
        }
        GcInfo gc = this.maker.buildGc(attributes);
        this.linker.onGc(parentObj, gc);
        this.objects.push(gc);
        this.tags.push(qName);
    }

    private void parseForMessage(MessageInfo parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.objects.push(parentObj);
        this.tags.push(qName);
    }

    private void parseForOs(OsInfo parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        this.objects.push(parentObj);
        this.tags.push(qName);
    }

    private void parseForRuntime(RuntimeInfo parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"user-dir".equals(qName) && !"java-classpath".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under runtime!", qName));
        }
        this.objects.push(parentObj);
        this.tags.push(qName);
    }

    private void parseForStatus(StatusInfo parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if ("runtime".equals(qName)) {
            RuntimeInfo runtime = this.maker.buildRuntime(attributes);
            this.linker.onRuntime(parentObj, runtime);
            this.objects.push(runtime);
        } else if ("os".equals(qName)) {
            OsInfo os = this.maker.buildOs(attributes);
            this.linker.onOs(parentObj, os);
            this.objects.push(os);
        } else if ("disk".equals(qName)) {
            DiskInfo disk = this.maker.buildDisk(attributes);
            this.linker.onDisk(parentObj, disk);
            this.objects.push(disk);
        } else if ("memory".equals(qName)) {
            MemoryInfo memory = this.maker.buildMemory(attributes);
            this.linker.onMemory(parentObj, memory);
            this.objects.push(memory);
        } else if ("thread".equals(qName)) {
            ThreadsInfo thread = this.maker.buildThread(attributes);
            this.linker.onThread(parentObj, thread);
            this.objects.push(thread);
        } else if ("message".equals(qName)) {
            MessageInfo message = this.maker.buildMessage(attributes);
            this.linker.onMessage(parentObj, message);
            this.objects.push(message);
        } else if ("extension".equals(qName)) {
            Extension extension = this.maker.buildExtension(attributes);
            this.linker.onExtension(parentObj, extension);
            this.objects.push(extension);
        } else if ("customInfo".equals(qName)) {
            CustomInfo customInfo = this.maker.buildCustomInfo(attributes);
            this.linker.onCustomInfo(parentObj, customInfo);
            this.objects.push(customInfo);
        } else {
            throw new SAXException(String.format("Element(%s) is not expected under status!", qName));
        }
        this.tags.push(qName);
    }

    private void parseForThread(ThreadsInfo parentObj, String parentTag, String qName, Attributes attributes) throws SAXException {
        if (!"dump".equals(qName)) {
            throw new SAXException(String.format("Element(%s) is not expected under thread!", qName));
        }
        this.objects.push(parentObj);
        this.tags.push(qName);
    }

    private void parseRoot(String qName, Attributes attributes) throws SAXException {
        if ("status".equals(qName)) {
            StatusInfo status;
            this.entity = status = this.maker.buildStatus(attributes);
            this.objects.push(status);
            this.tags.push(qName);
        } else if ("runtime".equals(qName)) {
            RuntimeInfo runtime;
            this.entity = runtime = this.maker.buildRuntime(attributes);
            this.objects.push(runtime);
            this.tags.push(qName);
        } else if ("os".equals(qName)) {
            OsInfo os;
            this.entity = os = this.maker.buildOs(attributes);
            this.objects.push(os);
            this.tags.push(qName);
        } else if ("memory".equals(qName)) {
            MemoryInfo memory;
            this.entity = memory = this.maker.buildMemory(attributes);
            this.objects.push(memory);
            this.tags.push(qName);
        } else if ("thread".equals(qName)) {
            ThreadsInfo thread;
            this.entity = thread = this.maker.buildThread(attributes);
            this.objects.push(thread);
            this.tags.push(qName);
        } else if ("disk".equals(qName)) {
            DiskInfo disk;
            this.entity = disk = this.maker.buildDisk(attributes);
            this.objects.push(disk);
            this.tags.push(qName);
        } else if ("disk-volume".equals(qName)) {
            DiskVolumeInfo diskVolume;
            this.entity = diskVolume = this.maker.buildDiskVolume(attributes);
            this.objects.push(diskVolume);
            this.tags.push(qName);
        } else if ("message".equals(qName)) {
            MessageInfo message;
            this.entity = message = this.maker.buildMessage(attributes);
            this.objects.push(message);
            this.tags.push(qName);
        } else if ("gc".equals(qName)) {
            GcInfo gc;
            this.entity = gc = this.maker.buildGc(attributes);
            this.objects.push(gc);
            this.tags.push(qName);
        } else if ("extension".equals(qName)) {
            Extension extension;
            this.entity = extension = this.maker.buildExtension(attributes);
            this.objects.push(extension);
            this.tags.push(qName);
        } else if ("extensionDetail".equals(qName)) {
            ExtensionDetail extensionDetail;
            this.entity = extensionDetail = this.maker.buildExtensionDetail(attributes);
            this.objects.push(extensionDetail);
            this.tags.push(qName);
        } else if ("customInfo".equals(qName)) {
            CustomInfo customInfo;
            this.entity = customInfo = this.maker.buildCustomInfo(attributes);
            this.objects.push(customInfo);
            this.tags.push(qName);
        } else {
            throw new SAXException("Unknown root element(" + qName + ") found!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && uri.length() != 0) throw new SAXException(String.format("Namespace(%s) is not supported by %s.", uri, this.getClass().getName()));
        if (this.objects.isEmpty()) {
            this.parseRoot(qName, attributes);
        } else {
            Object parent = this.objects.peek();
            String tag = this.tags.peek();
            if (parent instanceof StatusInfo) {
                this.parseForStatus((StatusInfo)parent, tag, qName, attributes);
            } else if (parent instanceof RuntimeInfo) {
                this.parseForRuntime((RuntimeInfo)parent, tag, qName, attributes);
            } else if (parent instanceof OsInfo) {
                this.parseForOs((OsInfo)parent, tag, qName, attributes);
            } else if (parent instanceof MemoryInfo) {
                this.parseForMemory((MemoryInfo)parent, tag, qName, attributes);
            } else if (parent instanceof ThreadsInfo) {
                this.parseForThread((ThreadsInfo)parent, tag, qName, attributes);
            } else if (parent instanceof DiskInfo) {
                this.parseForDisk((DiskInfo)parent, tag, qName, attributes);
            } else if (parent instanceof DiskVolumeInfo) {
                this.parseForDiskVolume((DiskVolumeInfo)parent, tag, qName, attributes);
            } else if (parent instanceof MessageInfo) {
                this.parseForMessage((MessageInfo)parent, tag, qName, attributes);
            } else if (parent instanceof GcInfo) {
                this.parseForGc((GcInfo)parent, tag, qName, attributes);
            } else if (parent instanceof Extension) {
                this.parseForExtension((Extension)parent, tag, qName, attributes);
            } else if (parent instanceof ExtensionDetail) {
                this.parseForExtensionDetail((ExtensionDetail)parent, tag, qName, attributes);
            } else {
                if (!(parent instanceof CustomInfo)) throw new RuntimeException(String.format("Unknown entity(%s) under %s!", qName, parent.getClass().getName()));
                this.parseForCustomInfo((CustomInfo)parent, tag, qName, attributes);
            }
        }
        this.text.setLength(0);
    }

    protected Date toDate(String str, String format) {
        try {
            return new SimpleDateFormat(format).parse(str);
        }
        catch (ParseException e) {
            throw new RuntimeException(String.format("Unable to parse date(%s) in format(%s)!", str, format), e);
        }
    }
}

