/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Properties {
    public static StringPropertyAccessor forString() {
        return new StringPropertyAccessor();
    }

    public static class SystemPropertyProvider
    implements PropertyProvider {
        private boolean properties;
        private boolean env;
        private String name;

        public SystemPropertyProvider(boolean properties, boolean env) {
            this.properties = properties;
            this.env = env;
        }

        @Override
        public Object getProperty(String name) {
            String value = null;
            if (this.name != null) {
                name = this.name;
            }
            if (this.properties) {
                value = System.getProperty(name);
            }
            if (value == null && this.env) {
                value = System.getenv(name);
            }
            return value;
        }

        public SystemPropertyProvider setName(String name) {
            this.name = name;
            return this;
        }
    }

    public static class StringPropertyAccessor
    extends PropertyAccessor<String> {
        @Override
        public String getProperty(String name, String defaultValue) {
            Object value;
            Object object = value = name == null ? null : this.getProperty(name);
            if (value == null) {
                return defaultValue;
            }
            return value.toString();
        }
    }

    public static interface PropertyProvider {
        public Object getProperty(String var1);
    }

    public static abstract class PropertyAccessor<T> {
        private List<PropertyProvider> providers = new ArrayList<PropertyProvider>();

        public PropertyAccessor<T> fromEnv() {
            return this.fromEnv(null);
        }

        public PropertyAccessor<T> fromEnv(String name) {
            this.providers.add(new SystemPropertyProvider(false, true).setName(name));
            return this;
        }

        public PropertyAccessor<T> fromMap(Map<String, T> map) {
            return this.fromMap(map, null);
        }

        public PropertyAccessor<T> fromMap(Map<String, T> map, String name) {
            this.providers.add(new MapPropertyProvider<T>(map).setName(name));
            return this;
        }

        public PropertyAccessor<T> fromSystem() {
            return this.fromSystem(null);
        }

        public PropertyAccessor<T> fromSystem(String name) {
            this.providers.add(new SystemPropertyProvider(true, false).setName(name));
            return this;
        }

        protected Object getProperty(String name) {
            PropertyProvider provider;
            Object value = null;
            Iterator<PropertyProvider> iterator = this.providers.iterator();
            while (iterator.hasNext() && (value = (provider = iterator.next()).getProperty(name)) == null) {
            }
            return value;
        }

        public abstract T getProperty(String var1, T var2);
    }

    public static class MapPropertyProvider<T>
    implements PropertyProvider {
        private String name;
        private Map<String, T> map;

        public MapPropertyProvider(Map<String, T> map) {
            this.map = map;
        }

        @Override
        public Object getProperty(String name) {
            Object value = null;
            if (this.name != null) {
                name = this.name;
            }
            if (this.map != null) {
                value = this.map.get(name);
            }
            return value;
        }

        public MapPropertyProvider<T> setName(String name) {
            this.name = name;
            return this;
        }
    }
}

