/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.util;

import com.dianping.cat.log.CatLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class Threads {
    private static volatile Manager manager = new Manager();
    private static CatLogger logger = CatLogger.getInstance();

    public static void addListener(ThreadListener listener) {
        manager.addListener(listener);
    }

    public static ThreadGroupManager forGroup() {
        return manager.getThreadGroupManager("Background");
    }

    public static ThreadGroupManager forGroup(String name) {
        return manager.getThreadGroupManager(name);
    }

    public static ThreadPoolManager forPool() {
        return manager.getThreadPoolManager();
    }

    public static String getCallerClass() {
        return (String)RunnableThread.callerThreadLocal.get();
    }

    public static void removeListener(ThreadListener listener) {
        manager.removeListener(listener);
    }

    public static class ThreadPoolManager {
        private Thread.UncaughtExceptionHandler handler;
        private Map<String, ExecutorService> services = new LinkedHashMap<String, ExecutorService>();

        public ThreadPoolManager(Thread.UncaughtExceptionHandler handler) {
            this.handler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExecutorService getCachedThreadPool(String name) {
            ExecutorService service = this.services.get(name);
            if (service != null && service.isShutdown()) {
                this.services.remove(name);
                service = null;
            }
            if (service == null) {
                ThreadPoolManager threadPoolManager = this;
                synchronized (threadPoolManager) {
                    service = this.services.get(name);
                    if (service == null) {
                        DefaultThreadFactory factory = this.newThreadFactory(name);
                        service = Executors.newCachedThreadPool(factory);
                        this.services.put(name, service);
                        manager.onThreadPoolCreated(service, factory.getName());
                    }
                }
            }
            return service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExecutorService getFixedThreadPool(String name, int nThreads) {
            ExecutorService service = this.services.get(name);
            if (service != null && service.isShutdown()) {
                this.services.remove(name);
                service = null;
            }
            if (service == null) {
                ThreadPoolManager threadPoolManager = this;
                synchronized (threadPoolManager) {
                    service = this.services.get(name);
                    if (service == null) {
                        DefaultThreadFactory factory = this.newThreadFactory(name);
                        service = Executors.newFixedThreadPool(nThreads, factory);
                        this.services.put(name, service);
                        manager.onThreadPoolCreated(service, factory.getName());
                    }
                }
            }
            return service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ScheduledExecutorService getScheduledThreadPool(String name, int nThreads) {
            ExecutorService service = this.services.get(name);
            if (service != null && service.isShutdown()) {
                this.services.remove(name);
                service = null;
            }
            if (service == null) {
                ThreadPoolManager threadPoolManager = this;
                synchronized (threadPoolManager) {
                    service = this.services.get(name);
                    if (service == null) {
                        DefaultThreadFactory factory = this.newThreadFactory(name);
                        service = Executors.newScheduledThreadPool(nThreads, factory);
                        this.services.put(name, service);
                        manager.onThreadPoolCreated(service, factory.getName());
                    }
                }
            }
            return (ScheduledExecutorService)service;
        }

        DefaultThreadFactory newThreadFactory(String name) {
            DefaultThreadFactory factory = new DefaultThreadFactory(name);
            factory.setUncaughtExceptionHandler(this.handler);
            return factory;
        }

        public void shutdownAll() {
            for (ExecutorService service : this.services.values()) {
                service.shutdown();
            }
            boolean allTerminated = false;
            int count = 100;
            while (!allTerminated && count-- > 0) {
                try {
                    for (ExecutorService service : this.services.values()) {
                        if (service.isTerminated()) continue;
                        service.awaitTermination(10L, TimeUnit.MILLISECONDS);
                    }
                    allTerminated = true;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static interface ThreadListener {
        public void onThreadGroupCreated(ThreadGroup var1, String var2);

        public void onThreadPoolCreated(ExecutorService var1, String var2);

        public void onThreadStarting(Thread var1, String var2);

        public void onThreadStopping(Thread var1, String var2);

        public boolean onUncaughtException(Thread var1, Throwable var2);
    }

    public static class ThreadGroupManager {
        private DefaultThreadFactory factory;
        private ThreadGroup threadGroup;
        private boolean active;
        private boolean deamon;

        public ThreadGroupManager(Thread.UncaughtExceptionHandler handler, String name) {
            this.threadGroup = new ThreadGroup(name);
            this.factory = new DefaultThreadFactory(this.threadGroup);
            this.factory.setUncaughtExceptionHandler(handler);
            this.active = true;
            this.deamon = true;
        }

        public void awaitTermination(long time, TimeUnit unit) {
            long slice;
            for (long remaining = unit.toNanos(time); remaining > 0L; remaining -= slice) {
                int len = this.threadGroup.activeCount();
                Thread[] activeThreads = new Thread[len];
                int num = this.threadGroup.enumerate(activeThreads);
                boolean anyAlive = false;
                for (int i = 0; i < num; ++i) {
                    Thread thread = activeThreads[i];
                    if (!thread.isAlive()) continue;
                    anyAlive = true;
                    break;
                }
                if (!anyAlive) break;
                slice = 1000000L;
                LockSupport.parkNanos(slice);
            }
        }

        public ThreadGroup getThreadGroup() {
            return this.threadGroup;
        }

        public boolean isActive() {
            return this.active;
        }

        public ThreadGroupManager nonDaemon() {
            this.deamon = false;
            return this;
        }

        public void shutdown() {
            int len = this.threadGroup.activeCount();
            Thread[] activeThreads = new Thread[len];
            int num = this.threadGroup.enumerate(activeThreads);
            for (int i = 0; i < num; ++i) {
                Thread thread = activeThreads[i];
                if (thread instanceof RunnableThread) {
                    ((RunnableThread)thread).shutdown();
                    continue;
                }
                if (!thread.isAlive()) continue;
                thread.interrupt();
            }
            this.active = false;
        }

        public Thread start(Runnable runnable) {
            return this.start(runnable, this.deamon);
        }

        public Thread start(Runnable runnable, boolean deamon) {
            Thread thread = this.factory.newThread(runnable);
            logger.info("cat client start thread " + thread.getName());
            thread.setDaemon(deamon);
            thread.start();
            return thread;
        }
    }

    public static interface Task
    extends Runnable {
        public String getName();

        public void shutdown();
    }

    static class RunnableThread
    extends Thread {
        private Runnable target;
        private String caller;
        private static ThreadLocal<String> callerThreadLocal = new ThreadLocal();

        public RunnableThread(ThreadGroup threadGroup, Runnable target, String name, Thread.UncaughtExceptionHandler handler) {
            super(threadGroup, target, name);
            this.target = target;
            this.caller = this.getCaller();
            this.setDaemon(true);
            this.setUncaughtExceptionHandler(handler);
            if (this.getPriority() != 5) {
                this.setPriority(5);
            }
        }

        private String getCaller() {
            StackTraceElement[] elements = new Exception().getStackTrace();
            String prefix = Threads.class.getName() + "$";
            for (StackTraceElement element : elements) {
                String className = element.getClassName();
                if (className.startsWith(prefix)) continue;
                int pos = className.lastIndexOf(36);
                if (pos < 0) {
                    pos = className.lastIndexOf(46);
                }
                if (pos < 0) {
                    return className;
                }
                return className.substring(pos + 1);
            }
            return null;
        }

        public Runnable getTarget() {
            return this.target;
        }

        @Override
        public void run() {
            callerThreadLocal.set(this.caller);
            manager.onThreadStarting(this, this.getName());
            super.run();
            manager.onThreadStopped(this, this.getName());
            callerThreadLocal.remove();
        }

        public void shutdown() {
            if (this.target instanceof Task) {
                ((Task)this.target).shutdown();
            } else {
                CatLogger.getInstance().info(String.format("Thread(%s) is shutdown! ", this.getName()));
                this.interrupt();
            }
        }
    }

    static class Manager
    implements Thread.UncaughtExceptionHandler {
        private Map<String, ThreadGroupManager> groupManagers = new LinkedHashMap<String, ThreadGroupManager>();
        private List<ThreadListener> listeners = new ArrayList<ThreadListener>();
        private ThreadPoolManager threadPoolManager;

        public Manager() {
            Thread shutdownThread = new Thread(){

                @Override
                public void run() {
                    this.shutdownAll();
                }
            };
            this.threadPoolManager = new ThreadPoolManager(this);
            shutdownThread.setDaemon(true);
            Runtime.getRuntime().addShutdownHook(shutdownThread);
        }

        public void addListener(ThreadListener listener) {
            this.listeners.add(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ThreadGroupManager getThreadGroupManager(String name) {
            ThreadGroupManager groupManager = this.groupManagers.get(name);
            if (groupManager == null) {
                Manager manager = this;
                synchronized (manager) {
                    groupManager = this.groupManagers.get(name);
                    if (groupManager != null && !groupManager.isActive()) {
                        this.groupManagers.remove(name);
                        groupManager = null;
                    }
                    if (groupManager == null) {
                        groupManager = new ThreadGroupManager(this, name);
                        this.groupManagers.put(name, groupManager);
                        this.onThreadGroupCreated(groupManager.getThreadGroup(), name);
                    }
                }
            }
            return groupManager;
        }

        public ThreadPoolManager getThreadPoolManager() {
            return this.threadPoolManager;
        }

        public void onThreadGroupCreated(ThreadGroup group, String name) {
            for (ThreadListener listener : this.listeners) {
                try {
                    listener.onThreadGroupCreated(group, name);
                }
                catch (Exception e) {
                    CatLogger.getInstance().error(e.getMessage(), e);
                }
            }
        }

        public void onThreadPoolCreated(ExecutorService service, String name) {
            for (ThreadListener listener : this.listeners) {
                try {
                    listener.onThreadPoolCreated(service, name);
                }
                catch (Exception e) {
                    CatLogger.getInstance().error(e.getMessage(), e);
                }
            }
        }

        public void onThreadStarting(Thread thread, String name) {
            for (ThreadListener listener : this.listeners) {
                try {
                    listener.onThreadStarting(thread, name);
                }
                catch (Exception e) {
                    CatLogger.getInstance().error(e.getMessage(), e);
                }
            }
        }

        public void onThreadStopped(Thread thread, String name) {
            for (ThreadListener listener : this.listeners) {
                try {
                    listener.onThreadStopping(thread, name);
                }
                catch (Exception e) {
                    CatLogger.getInstance().error(e.getMessage(), e);
                }
            }
        }

        public void removeListener(ThreadListener listener) {
            this.listeners.remove(listener);
        }

        public void shutdownAll() {
            for (ThreadGroupManager manager : this.groupManagers.values()) {
                manager.shutdown();
            }
            this.threadPoolManager.shutdownAll();
        }

        @Override
        public void uncaughtException(Thread thread, Throwable e) {
            ThreadListener listener;
            boolean handled;
            Iterator<ThreadListener> iterator = this.listeners.iterator();
            while (iterator.hasNext() && !(handled = (listener = iterator.next()).onUncaughtException(thread, e))) {
            }
        }
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        private ThreadGroup threadGroup;
        private String name;
        private AtomicInteger index = new AtomicInteger();
        private Thread.UncaughtExceptionHandler handler;

        public DefaultThreadFactory(String name) {
            this.threadGroup = new ThreadGroup(name);
            this.name = name;
        }

        public DefaultThreadFactory(ThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
            this.name = threadGroup.getName();
        }

        public String getName() {
            return this.name;
        }

        @Override
        public Thread newThread(Runnable r) {
            int nextIndex = this.index.getAndIncrement();
            String threadName = r instanceof Task ? this.name + "-" + ((Task)r).getName() : this.name + "-" + nextIndex;
            return new RunnableThread(this.threadGroup, r, threadName, this.handler);
        }

        public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
            this.handler = handler;
        }
    }

    public static abstract class AbstractThreadListener
    implements ThreadListener {
        @Override
        public void onThreadGroupCreated(ThreadGroup group, String name) {
        }

        @Override
        public void onThreadPoolCreated(ExecutorService pool, String name) {
        }

        @Override
        public void onThreadStarting(Thread thread, String name) {
        }

        @Override
        public void onThreadStopping(Thread thread, String name) {
        }

        @Override
        public boolean onUncaughtException(Thread thread, Throwable e) {
            return false;
        }
    }
}

