/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.util;

import com.dianping.cat.util.Files;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Urls {
    public static UrlIO forIO() {
        return new UrlIO();
    }

    public static class UrlIO {
        private int readTimeout;
        private int connectTimeout;
        private Map<String, String> headers = new HashMap<String, String>();

        public UrlIO connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public UrlIO header(String name, String value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put(name, value);
            return this;
        }

        public void copy(String url, OutputStream out) throws IOException {
            Files.forIO().copy(this.openStream(url), out, Files.AutoClose.INPUT);
        }

        public InputStream openStream(String url) throws IOException {
            return this.openStream(url, null);
        }

        public InputStream openStream(String url, Map<String, List<String>> responseHeaders) throws IOException {
            URLConnection conn = new URL(url).openConnection();
            if (this.connectTimeout > 0) {
                conn.setConnectTimeout(this.connectTimeout);
            }
            if (this.readTimeout > 0) {
                conn.setReadTimeout(this.readTimeout);
            }
            if (this.headers != null) {
                for (Map.Entry<String, String> e : this.headers.entrySet()) {
                    conn.setRequestProperty(e.getKey(), e.getValue());
                }
            }
            if (responseHeaders != null) {
                responseHeaders.putAll(conn.getHeaderFields());
            }
            return conn.getInputStream();
        }

        public UrlIO readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }
    }
}

