/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DomainConfig {
    private Map<Integer, DomainConfigDetail> domainConfig;
    private String domainHash;
    private Map<String, Integer> allDomainUrlGapMap;

    public Map<Integer, DomainConfigDetail> getDomainConfig() {
        return this.domainConfig;
    }

    public boolean hasDomainConfig() {
        return this.domainConfig != null && this.domainConfig.size() > 0;
    }

    public void initDomainConfig(List<String> domainUrls) {
        HashMap<Integer, DomainConfigDetail> map = new HashMap<Integer, DomainConfigDetail>();
        for (int i = 1; i <= domainUrls.size(); ++i) {
            DomainConfigDetail domainConfigDetail = new DomainConfigDetail();
            domainConfigDetail.addUrl(domainUrls.get(i - 1));
            map.put(i, domainConfigDetail);
        }
        this.domainConfig = map;
        this.allDomainUrlGapMap = null;
    }

    public void setDomainConfig(Map<Integer, DomainConfigDetail> domainConfig) {
        this.domainConfig = domainConfig;
        this.allDomainUrlGapMap = null;
    }

    public String getDomainHash() {
        return this.domainHash == null ? "" : this.domainHash;
    }

    public void setDomainHash(String domainHash) {
        this.domainHash = domainHash;
    }

    public List<String> getAllDomainUrlList() {
        ArrayList<String> list = new ArrayList<String>();
        for (DomainConfigDetail domainConfigDetail : this.domainConfig.values()) {
            list.addAll(domainConfigDetail.getUrls());
        }
        return list;
    }

    public Map<String, Integer> getAllDomainUrlPriority() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Integer key : this.domainConfig.keySet()) {
            for (String url : this.domainConfig.get(key).getUrls()) {
                map.put(url, key);
            }
        }
        return map;
    }

    public Map<String, Integer> getAllDomainUrlGap() {
        if (this.allDomainUrlGapMap != null) {
            return this.allDomainUrlGapMap;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<Integer> keys = new ArrayList<Integer>(this.domainConfig.keySet());
        int gap = 0;
        for (int i = keys.size() - 1; i >= 0; --i) {
            if (i != keys.size() - 1) {
                gap += this.domainConfig.get(keys.get(i)).getPriorityGap().intValue();
            }
            for (String url : this.domainConfig.get(keys.get(i)).getUrls()) {
                map.put(url, gap);
            }
        }
        this.allDomainUrlGapMap = map;
        return this.allDomainUrlGapMap;
    }

    public List<Map.Entry<Integer, DomainConfigDetail>> getDescendDomainConfig() {
        ArrayList<Map.Entry<Integer, DomainConfigDetail>> list = new ArrayList<Map.Entry<Integer, DomainConfigDetail>>(this.domainConfig.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Integer, DomainConfigDetail>>(){

            @Override
            public int compare(Map.Entry<Integer, DomainConfigDetail> o1, Map.Entry<Integer, DomainConfigDetail> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return list;
    }

    public class DomainConfigDetail {
        private List<String> urls;
        private Integer priorityGap = 30;

        public List<String> getUrls() {
            return this.urls;
        }

        public void addUrl(String url) {
            if (this.urls == null) {
                this.urls = new ArrayList<String>();
            }
            this.urls.add(url);
        }

        public void setUrls(List<String> urls) {
            this.urls = urls;
        }

        public Integer getPriorityGap() {
            return this.priorityGap;
        }

        public void setPriorityGap(Integer priorityGap) {
            this.priorityGap = priorityGap;
        }
    }
}

