/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http.utils;

import com.gexin.fastjson.JSONObject;
import com.gexin.rp.sdk.base.domain.DomainCheck;
import com.gexin.rp.sdk.base.domain.DomainListBO;
import com.gexin.rp.sdk.base.domain.IDomainCheck;
import com.gexin.rp.sdk.http.utils.DomainConfig;
import com.gexin.rp.sdk.http.utils.DomainState;
import com.gexin.rp.sdk.http.utils.GTConfig;
import com.gexin.rp.sdk.http.utils.PushDomainManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class OSDomainWrapper
implements IDomainCheck {
    private String appKey;
    private List<String> domainUrls;
    private boolean isSSL;
    private boolean isAssigned;
    private DomainConfig domainConfig;
    private String domainHash = "";
    private String mainUrl;
    private String standbyUrl;
    private Map<String, DomainState> domainStateMap = new LinkedHashMap<String, DomainState>();
    private boolean isMainUrlFusing;
    private AtomicInteger allFusingCount = new AtomicInteger(0);
    private AtomicInteger intervalFusingCount = new AtomicInteger(0);

    public boolean isMainUrlFusing() {
        return this.isMainUrlFusing;
    }

    public void setMainUrlFusing(boolean mainUrlFusing) {
        this.isMainUrlFusing = mainUrlFusing;
    }

    public DomainConfig getDomainConfig() {
        return this.domainConfig;
    }

    public void setDomainConfig(DomainConfig domainConfig) {
        this.domainConfig = domainConfig;
    }

    public String getDomainHash() {
        return this.domainHash;
    }

    public void setDomainHash(String domainHash) {
        this.domainHash = domainHash;
    }

    public String getMainUrl() {
        return this.mainUrl;
    }

    public void setMainUrl(String mainUrl) {
        this.mainUrl = mainUrl;
    }

    public String getStandbyUrl() {
        return this.standbyUrl;
    }

    public void setStandbyUrl(String standbyUrl) {
        this.standbyUrl = standbyUrl;
    }

    public OSDomainWrapper(String appKey, boolean isSSL, boolean isAssigned, List<String> domainUrls) {
        this.appKey = appKey;
        this.isSSL = isSSL;
        this.isAssigned = domainUrls == null ? false : isAssigned;
        this.domainUrls = domainUrls;
    }

    public void setDomainUrls(List<String> domainUrls) {
        this.domainUrls = domainUrls;
    }

    public boolean isFailCountOverLimit(String url) {
        if (this.domainStateMap.get(url) == null) {
            return false;
        }
        return this.domainStateMap.get(url).getContinuousFailCount().incrementAndGet() >= GTConfig.getHttpFailCount();
    }

    public void reSetdomainState() {
        for (DomainState domainState : this.domainStateMap.values()) {
            domainState.reset();
        }
    }

    public void reSetContinuousFailCount(String url) {
        DomainState domainState = this.domainStateMap.get(url);
        if (domainState != null) {
            domainState.getContinuousFailCount().set(0);
        }
    }

    public void reSetAllContinuousFailCount() {
        for (DomainState domainState : this.domainStateMap.values()) {
            domainState.getContinuousFailCount().set(0);
        }
    }

    public void incrementUseCount(String url) {
        DomainState domainState = this.domainStateMap.get(url);
        if (domainState != null) {
            domainState.getUseCount().incrementAndGet();
        }
    }

    public void incrementFailCount(String url) {
        DomainState domainState = this.domainStateMap.get(url);
        if (domainState != null) {
            domainState.getFailCount().incrementAndGet();
        }
    }

    public void incrementAllFusingCount() {
        this.allFusingCount.incrementAndGet();
    }

    public AtomicInteger getAllFusingCount() {
        return this.allFusingCount;
    }

    public void incrementIntervalFusingCount() {
        this.intervalFusingCount.incrementAndGet();
    }

    public AtomicInteger getIntervalFusingCount() {
        return this.intervalFusingCount;
    }

    public Map<String, DomainState> getDomainStateMap() {
        return this.domainStateMap;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public List<String> getDomainUrls() {
        return this.domainUrls;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public boolean isAssigned() {
        return this.isAssigned;
    }

    public void assignUseDomaim() {
        this.mainUrl = (String)this.domainStateMap.keySet().toArray()[0];
        if (this.domainStateMap.size() > 1) {
            this.standbyUrl = (String)this.domainStateMap.keySet().toArray()[1];
        }
    }

    public boolean isSingleDomain() {
        return this.getDomainConfig().getAllDomainUrlList().size() == 1;
    }

    public List<String> sortDomainByRule() {
        ArrayList<DomainListBO> domainBOS = new ArrayList<DomainListBO>();
        List<Map.Entry<Integer, DomainConfig.DomainConfigDetail>> list = this.domainConfig.getDescendDomainConfig();
        for (Map.Entry<Integer, DomainConfig.DomainConfigDetail> entry : list) {
            DomainListBO domainListBO = new DomainListBO();
            domainListBO.setPriorityGap(entry.getValue().getPriorityGap());
            domainListBO.setDomainList(entry.getValue().getUrls());
            domainBOS.add(domainListBO);
        }
        List s = new DomainCheck((IDomainCheck)this, 15).sort(domainBOS);
        return s;
    }

    public String getUsableDomainUrl() {
        if (this.isAssigned) {
            return this.mainUrl;
        }
        if (!this.isMainUrlFusing) {
            return this.mainUrl;
        }
        if (this.isAllDomainUrlBad()) {
            return this.domainUrls.get(0);
        }
        return this.standbyUrl;
    }

    private boolean isAllDomainUrlBad() {
        for (DomainState domainState : this.domainStateMap.values()) {
            if (domainState.getContinuousFailCount().intValue() >= 3) continue;
            return false;
        }
        return true;
    }

    public String getUsableStandbyUrl() {
        for (String url : this.domainStateMap.keySet()) {
            DomainState domainState = this.domainStateMap.get(url);
            if (domainState.getContinuousFailCount().intValue() >= 3) continue;
            return url;
        }
        return this.getDomainUrls().get(0);
    }

    public void addSingleTime(String url, long cost) {
        DomainState domainState = this.domainStateMap.get(url);
        if (domainState != null) {
            domainState.addSingleTime(cost);
        }
    }

    public void incrementSingleCount(String url) {
        DomainState domainState = this.domainStateMap.get(url);
        if (domainState != null) {
            domainState.getSingleCount().incrementAndGet();
        }
    }

    public void addBatchTime(String url, long cost) {
        DomainState domainState = this.domainStateMap.get(url);
        if (domainState != null) {
            domainState.addBatchTime(cost);
        }
    }

    public void incrementBatchCount(String url) {
        DomainState domainState = this.domainStateMap.get(url);
        if (domainState != null) {
            domainState.getBatchCount().incrementAndGet();
        }
    }

    public void addListTime(String url, long cost) {
        DomainState domainState = this.domainStateMap.get(url);
        if (domainState != null) {
            domainState.addListTime(cost);
        }
    }

    public void incrementListCount(String url) {
        DomainState domainState = this.domainStateMap.get(url);
        if (domainState != null) {
            domainState.getListCount().incrementAndGet();
        }
    }

    public void addAppTime(String url, long cost) {
        DomainState domainState = this.domainStateMap.get(url);
        if (domainState != null) {
            domainState.addAppTime(cost);
        }
    }

    public void incrementAppCount(String url) {
        DomainState domainState = this.domainStateMap.get(url);
        if (domainState != null) {
            domainState.getAppCount().incrementAndGet();
        }
    }

    public String getAllDomainState() {
        return JSONObject.toJSONString(this.domainStateMap);
    }

    public void initDomainStateMap() {
        this.updateDomainStateMap(this.domainConfig.getAllDomainUrlList());
    }

    public void updateDomainStateMap(List<String> urls) {
        LinkedHashMap<String, DomainState> map = new LinkedHashMap<String, DomainState>();
        Iterator<String> i$ = urls.iterator();
        while (i$.hasNext()) {
            String url;
            DomainState domainState = this.domainStateMap.get(url = i$.next());
            map.put(url, domainState == null ? new DomainState() : domainState);
        }
        this.domainStateMap = map;
    }

    public boolean check(final Object o) {
        FutureTask<Boolean> task = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                PushDomainManager.detectHost(String.valueOf(o));
                return true;
            }
        });
        try {
            new Thread(task, "detectHost").start();
            boolean result = task.get(1L, TimeUnit.SECONDS);
            if (result) {
                return true;
            }
        }
        catch (TimeoutException e) {
            task.cancel(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

