/*
 * Decompiled with CFR 0.152.
 */
package com.gexin.rp.sdk.http.utils;

import com.gexin.fastjson.JSONObject;
import com.gexin.rp.sdk.http.GtHttpProxy;
import com.gexin.rp.sdk.http.client.GtHttpClient;
import com.gexin.rp.sdk.http.utils.DomainConfig;
import com.gexin.rp.sdk.http.utils.GTConfig;
import com.gexin.rp.sdk.http.utils.OSDomainWrapper;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class PushDomainManager {
    private static final GtHttpClient client = new GtHttpClient(GTConfig.getHttpConnectionTimeOut(), GTConfig.getHttpSoTimeOut(), 1);
    public static final Map<String, OSDomainWrapper> domainMap = new ConcurrentHashMap<String, OSDomainWrapper>();
    private static AtomicBoolean isScreenDomain = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void screenDomain() {
        try {
            for (String key : domainMap.keySet()) {
                List<String> domains;
                OSDomainWrapper oSDomainWrapper = domainMap.get(key);
                if (oSDomainWrapper.isSingleDomain() || (domains = oSDomainWrapper.sortDomainByRule()) == null || domains.isEmpty()) continue;
                oSDomainWrapper.updateDomainStateMap(domains);
                oSDomainWrapper.assignUseDomaim();
                PushDomainManager.clearStatus(oSDomainWrapper);
            }
        }
        catch (Exception exception) {
        }
        finally {
            isScreenDomain.compareAndSet(true, false);
        }
    }

    private static void clearStatus(OSDomainWrapper oSDomainWrapper) {
        oSDomainWrapper.setMainUrlFusing(false);
        oSDomainWrapper.reSetAllContinuousFailCount();
    }

    private static long getResponseTime(String host) {
        try {
            long start = System.currentTimeMillis();
            client.executeHead(host);
            long end = System.currentTimeMillis();
            return end - start;
        }
        catch (Throwable e) {
            return Long.MAX_VALUE;
        }
    }

    public static boolean detectHost(String host) throws Exception {
        return client.executeHead(host);
    }

    public static void initOSDomain(String domainKey, OSDomainWrapper wrapper) {
        if (!wrapper.isAssigned()) {
            List<String> domainUrls = wrapper.getDomainUrls();
            if (domainUrls == null) {
                domainUrls = GTConfig.getDefaultDomainUrl(wrapper.isSSL());
                wrapper.setDomainUrls(domainUrls);
            }
            PushDomainManager.getDomainConfig(wrapper, domainUrls);
        }
        if (wrapper.getDomainConfig() == null) {
            DomainConfig domainConfig = new DomainConfig();
            domainConfig.initDomainConfig(wrapper.getDomainUrls());
            wrapper.setDomainConfig(domainConfig);
        }
        wrapper.initDomainStateMap();
        wrapper.assignUseDomaim();
        PushDomainManager.addOSDomainWrapper(domainKey, wrapper);
        PushDomainManager.cycleTestAsync();
    }

    private static void getDomainConfig(OSDomainWrapper wrapper, List<String> domainUrls) {
        Map<String, Object> rst = PushDomainManager.getDomainConfig(domainUrls, wrapper.getAppKey());
        if (rst != null) {
            if (rst.get("domainConfig") != null) {
                wrapper.setDomainConfig((DomainConfig)rst.get("domainConfig"));
            }
            if (rst.get("domainHash") != null) {
                wrapper.setDomainHash((String)rst.get("domainHash"));
            }
        }
    }

    private static Map<String, Object> getDomainConfig(List<String> hosts, String appKey) {
        HashMap<String, Object> postData = new HashMap<String, Object>(2);
        postData.put("action", "getDomainConfigAction");
        postData.put("appkey", appKey);
        Exception ex = null;
        for (String host : hosts) {
            try {
                Map<String, Object> response = client.executePostJson(host, postData, false, false);
                String domainConfig = (String)response.get("domainConfig");
                String result = (String)response.get("result");
                if (!"ok".equals(result)) continue;
                HashMap<String, Object> rst = new HashMap<String, Object>();
                if (domainConfig != null) {
                    DomainConfig domainConfigDto = (DomainConfig)JSONObject.parseObject((String)domainConfig, DomainConfig.class);
                    rst.put("domainConfig", domainConfigDto);
                    rst.put("domainHash", response.get("domainHash"));
                    return rst;
                }
                rst.put("domainHash", response.get("domainHash"));
                return rst;
            }
            catch (Exception e) {
                ex = e;
            }
        }
        return null;
    }

    public static void notifyDomainError(String domainKey, DomainConfig domainConfig) {
        OSDomainWrapper wrapper = domainMap.get(domainKey);
        if (wrapper == null || domainConfig == null || !domainConfig.hasDomainConfig()) {
            return;
        }
        wrapper.setDomainConfig(domainConfig);
        wrapper.initDomainStateMap();
        wrapper.assignUseDomaim();
        PushDomainManager.cycleTestAsync();
    }

    public static void notifyServerError(String domainKey, String url) {
        OSDomainWrapper wrapper = domainMap.get(domainKey);
        if (wrapper == null) {
            return;
        }
        if (wrapper.isFailCountOverLimit(url)) {
            if (url.equals(wrapper.getMainUrl())) {
                wrapper.setMainUrlFusing(true);
                wrapper.incrementAllFusingCount();
                wrapper.incrementIntervalFusingCount();
            } else {
                wrapper.setStandbyUrl(wrapper.getUsableStandbyUrl());
            }
            PushDomainManager.cycleTestAsync();
        }
    }

    public static void cycleTestAsync() {
        if (isScreenDomain.compareAndSet(false, true)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PushDomainManager.screenDomain();
                }
            }, "screenDomain").start();
        }
    }

    public static String getMainUrl(String domainKey) {
        return domainMap.get(domainKey).getMainUrl();
    }

    public static void reSetContinuousFailCount(String domainKey, String url) {
        domainMap.get(domainKey).reSetContinuousFailCount(url);
    }

    public static void incrementUseCount(String domainKey, String url) {
        domainMap.get(domainKey).incrementUseCount(url);
    }

    public static void incrementFailCount(String domainKey, String url) {
        domainMap.get(domainKey).incrementFailCount(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addOSDomainWrapper(String domainKey, OSDomainWrapper wrapper) {
        if (wrapper == null) {
            return;
        }
        Map<String, OSDomainWrapper> map = domainMap;
        synchronized (map) {
            domainMap.put(domainKey, wrapper);
        }
    }

    public static void initProxy(GtHttpProxy proxy) {
        client.setProxy(proxy);
    }

    public static String getDomainUrl(String domainKey) {
        OSDomainWrapper osDomainWrapper = domainMap.get(domainKey);
        return osDomainWrapper.getUsableDomainUrl();
    }

    public static String buildSerial() {
        int p = PushDomainManager.getProcessID();
        return p + "-" + System.currentTimeMillis() + "-" + new Random().nextInt(10000);
    }

    public static final int getProcessID() {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            return Integer.valueOf(runtimeMXBean.getName().split("@")[0]);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    static {
        Thread screenDomainThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        if (!isScreenDomain.compareAndSet(false, true)) continue;
                        PushDomainManager.screenDomain();
                        continue;
                    }
                    finally {
                        try {
                            Thread.sleep(GTConfig.getScreenDomainInterval());
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
        }, "screenDomainThread");
        screenDomainThread.setDaemon(true);
        screenDomainThread.start();
    }
}

