/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.config.SpringContextUtils;
import com.github.alenfive.rocketapi.datasource.DataSourceManager;
import com.github.alenfive.rocketapi.entity.ApiInfo;
import com.github.alenfive.rocketapi.entity.ApiParams;
import com.github.alenfive.rocketapi.entity.vo.IgnoreWrapper;
import com.github.alenfive.rocketapi.extend.ApiInfoContent;
import com.github.alenfive.rocketapi.extend.IApiInfoCache;
import com.github.alenfive.rocketapi.extend.IRequestInterceptor;
import com.github.alenfive.rocketapi.extend.IResultWrapper;
import com.github.alenfive.rocketapi.extend.IScriptEncrypt;
import com.github.alenfive.rocketapi.script.IScriptParse;
import com.github.alenfive.rocketapi.service.ApiInfoService;
import com.github.alenfive.rocketapi.service.ConfigService;
import com.github.alenfive.rocketapi.service.DataSourceService;
import com.github.alenfive.rocketapi.service.ScriptParseService;
import com.github.alenfive.rocketapi.utils.PackageUtils;
import com.github.alenfive.rocketapi.utils.RequestUtils;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Component
public class QLRequestMappingFactory
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(QLRequestMappingFactory.class);
    @Autowired
    private ScriptParseService parseService;
    @Autowired
    private ApiInfoContent apiInfoContent;
    @Autowired
    @Lazy
    private IScriptParse scriptParse;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private DataSourceManager dataSourceManager;
    @Autowired
    private RocketApiProperties rocketApiProperties;
    @Autowired
    private IApiInfoCache apiInfoCache;
    @Autowired
    private IResultWrapper resultWrapper;
    @Autowired
    private IScriptEncrypt scriptEncrypt;
    @Autowired
    private ServerProperties serverProperties;
    @Autowired
    private ConfigService configService;
    @Autowired
    private ApiInfoService apiInfoService;
    @Autowired
    private IRequestInterceptor requestInterceptor;
    @Autowired
    private SpringContextUtils springContextUtils;
    @Autowired
    private DataSourceService dataSourceService;
    private List<String> bodyMethods = Arrays.asList("POST", "PUT", "PATCH");

    @PostConstruct
    public void buildInit() throws Exception {
        this.reInit(true);
    }

    public void reInit(Boolean isStart) throws Exception {
        this.dataSourceManager.setParseService(this.parseService);
        this.loadBanner();
        this.configService.reloadApiConfig(isStart);
        this.apiInfoService.reLoadApiInfo(isStart);
        try {
            this.dataSourceService.reLoadDBConfig(isStart);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadBanner() {
        System.out.println("__________               __           __       _____ __________.___ \n\\______   \\ ____   ____ |  | __ _____/  |_    /  _  \\\\______   \\   |\n |       _//  _ \\_/ ___\\|  |/ // __ \\   __\\  /  /_\\  \\|     ___/   |\n |    |   (  <_> )  \\___|    <\\  ___/|  |   /    |    \\    |   |   |\n |____|_  /\\____/ \\___  >__|_ \\\\___  >__|   \\____|__  /____|   |___|\n        \\/            \\/     \\/    \\/               \\/              \n\u001b[32;2m:: Rocket API ::\u001b[m        (" + PackageUtils.getVersion() + ")   " + this.buildLocalLink());
    }

    private String buildLocalLink() {
        String content = this.serverProperties.getServlet().getContextPath() == null ? "" : this.serverProperties.getServlet().getContextPath();
        Integer port = this.serverProperties.getPort() == null ? 8080 : this.serverProperties.getPort();
        return "http://localhost:" + port + ("/" + content + this.rocketApiProperties.getBaseRegisterPath()).replace("//", "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping
    @ResponseBody
    public ResponseEntity execute(@PathVariable(required=false) Map<String, String> pathVar, @RequestParam(required=false) Map<String, Object> param, HttpServletRequest request, HttpServletResponse response) throws Throwable {
        String path = RequestUtils.buildPattern(request);
        String method = request.getMethod();
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (this.bodyMethods.contains(method)) {
            if (request.getContentType() != null && request.getContentType().indexOf("application/json") > -1) {
                try {
                    Object bodyObject = this.objectMapper.readValue((InputStream)request.getInputStream(), Object.class);
                    if (bodyObject instanceof Map) {
                        body.putAll((Map)bodyObject);
                    }
                    body.put(this.rocketApiProperties.getBodyRootKey(), bodyObject);
                }
                catch (MismatchedInputException exception) {
                    throw new HttpMessageNotReadableException("Required request body is missing", (Throwable)exception, (HttpInputMessage)new ServletServerHttpRequest(request));
                }
            } else if (request.getContentType() != null && request.getContentType().indexOf("multipart/form-data") > -1) {
                MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
                body.putAll((Map<String, Object>)multipartHttpServletRequest.getMultiFileMap());
                body.put(this.rocketApiProperties.getBodyRootKey(), multipartHttpServletRequest.getMultiFileMap());
            } else if (request.getContentType() != null && request.getContentType().indexOf("application/x-www-form-urlencoded") > -1) {
                HashMap parameterMap = new HashMap(request.getParameterMap().size());
                request.getParameterMap().forEach((key, values) -> parameterMap.put(key, Arrays.asList(values)));
                body.putAll(parameterMap);
                body.put(this.rocketApiProperties.getBodyRootKey(), parameterMap);
            }
        }
        ApiParams apiParams = ApiParams.builder().pathVar(pathVar).header(RequestUtils.buildHeaderParams(request)).param(param).body(body).session(RequestUtils.buildSessionParams(request)).request(request).response(response).build();
        ApiInfo apiInfo = this.apiInfoCache.get(ApiInfo.builder().method(method).fullPath(path).build());
        StringBuilder script = new StringBuilder(this.scriptEncrypt.decrypt(apiInfo.getScript()));
        try {
            Boolean isProcess = this.requestInterceptor.preHandle(request, response, apiInfo, apiParams);
            Object data = null;
            if (isProcess.booleanValue()) {
                data = this.scriptParse.runScript(script.toString(), apiInfo, apiParams);
            }
            if (data instanceof ResponseEntity) {
                ResponseEntity responseEntity = (ResponseEntity)data;
                return responseEntity;
            }
            if (data instanceof IgnoreWrapper) {
                ResponseEntity responseEntity = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON_UTF8).body(((IgnoreWrapper)data).getData());
                return responseEntity;
            }
            ResponseEntity responseEntity = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON_UTF8).body(this.resultWrapper.wrapper(data, request, response));
            return responseEntity;
        }
        catch (Exception e) {
            e.printStackTrace();
            ResponseEntity responseEntity = ResponseEntity.ok().contentType(MediaType.APPLICATION_JSON_UTF8).body(this.resultWrapper.throwable(e, request, response));
            return responseEntity;
        }
        finally {
            this.apiInfoContent.removeAll();
        }
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        ApplicationContext parent = contextRefreshedEvent.getApplicationContext().getParent();
        if (parent == null) {
            this.reInit(true);
        }
    }
}

