/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.config;

import com.github.alenfive.rocketapi.config.QLRequestMappingFactory;
import com.github.alenfive.rocketapi.config.RefreshApiConfig;
import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.config.SpringContextUtils;
import com.github.alenfive.rocketapi.controller.ApiController;
import com.github.alenfive.rocketapi.controller.RemoteController;
import com.github.alenfive.rocketapi.controller.ViewController;
import com.github.alenfive.rocketapi.datasource.DataSourceManager;
import com.github.alenfive.rocketapi.datasource.factory.ClickHouseDriver;
import com.github.alenfive.rocketapi.datasource.factory.MongoDriver;
import com.github.alenfive.rocketapi.datasource.factory.MySQLDriver;
import com.github.alenfive.rocketapi.datasource.factory.OracleDriver;
import com.github.alenfive.rocketapi.datasource.factory.PostgreSQLDriver;
import com.github.alenfive.rocketapi.datasource.factory.SQLServerDriver;
import com.github.alenfive.rocketapi.extend.ApiInfoContent;
import com.github.alenfive.rocketapi.extend.DefaultApiDocSync;
import com.github.alenfive.rocketapi.extend.DefaultApiInfoCache;
import com.github.alenfive.rocketapi.extend.DefaultApiPager;
import com.github.alenfive.rocketapi.extend.DefaultAssertException;
import com.github.alenfive.rocketapi.extend.DefaultClusterNotify;
import com.github.alenfive.rocketapi.extend.DefaultDBCache;
import com.github.alenfive.rocketapi.extend.DefaultRequestInterceptor;
import com.github.alenfive.rocketapi.extend.DefaultResultWrapper;
import com.github.alenfive.rocketapi.extend.DefaultSQLInterceptor;
import com.github.alenfive.rocketapi.extend.DefaultScriptEncrypt;
import com.github.alenfive.rocketapi.extend.DefaultUserAuthorization;
import com.github.alenfive.rocketapi.extend.IApiDocSync;
import com.github.alenfive.rocketapi.extend.IApiInfoCache;
import com.github.alenfive.rocketapi.extend.IApiPager;
import com.github.alenfive.rocketapi.extend.IAssertException;
import com.github.alenfive.rocketapi.extend.IClusterNotify;
import com.github.alenfive.rocketapi.extend.IDBCache;
import com.github.alenfive.rocketapi.extend.IRequestInterceptor;
import com.github.alenfive.rocketapi.extend.IResultWrapper;
import com.github.alenfive.rocketapi.extend.ISQLInterceptor;
import com.github.alenfive.rocketapi.extend.IScriptEncrypt;
import com.github.alenfive.rocketapi.extend.IUserAuthorization;
import com.github.alenfive.rocketapi.function.AssertFunction;
import com.github.alenfive.rocketapi.function.ContextFunction;
import com.github.alenfive.rocketapi.function.DbFunction;
import com.github.alenfive.rocketapi.function.EnvFunction;
import com.github.alenfive.rocketapi.function.LogFunction;
import com.github.alenfive.rocketapi.function.MongoFunction;
import com.github.alenfive.rocketapi.function.PagerFunction;
import com.github.alenfive.rocketapi.function.UtilsFunction;
import com.github.alenfive.rocketapi.script.GroovyScriptParse;
import com.github.alenfive.rocketapi.script.IScriptParse;
import com.github.alenfive.rocketapi.service.ApiInfoService;
import com.github.alenfive.rocketapi.service.CompletionService;
import com.github.alenfive.rocketapi.service.ConfigService;
import com.github.alenfive.rocketapi.service.DataSourceService;
import com.github.alenfive.rocketapi.service.EncryptChangeService;
import com.github.alenfive.rocketapi.service.LoginService;
import com.github.alenfive.rocketapi.service.RequestMappingService;
import com.github.alenfive.rocketapi.service.ScriptParseService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@Configuration
@EnableConfigurationProperties(value={RocketApiProperties.class})
@ConditionalOnBean(value={DataSourceManager.class})
public class RocketApiAutoConfig {
    @Bean
    @ConditionalOnMissingBean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", this.buildConfig());
        return new CorsFilter((CorsConfigurationSource)source);
    }

    private CorsConfiguration buildConfig() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        return corsConfiguration;
    }

    @Bean
    @ConditionalOnMissingBean
    public RemoteController getRemoteController() {
        return new RemoteController();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"spring.rocket-api.view-enabled"}, havingValue="true", matchIfMissing=true)
    public ApiController getApiController() {
        return new ApiController();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"spring.rocket-api.view-enabled"}, havingValue="true", matchIfMissing=true)
    public ViewController getViewController() {
        return new ViewController();
    }

    @Bean
    @ConditionalOnMissingBean
    public QLRequestMappingFactory getQLRequestMappingFactory() {
        return new QLRequestMappingFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public IApiPager getApiPager() {
        return new DefaultApiPager();
    }

    @Bean
    @ConditionalOnMissingBean
    public ScriptParseService getScriptParseService() {
        return new ScriptParseService();
    }

    @Bean
    @ConditionalOnMissingBean
    public IResultWrapper getIResultWrapper() {
        return new DefaultResultWrapper();
    }

    @Bean
    @ConditionalOnMissingBean
    public IAssertException getDefaultAssertException() {
        return new DefaultAssertException();
    }

    @Bean
    @ConditionalOnMissingBean
    public IScriptParse getIScriptParse() {
        return new GroovyScriptParse();
    }

    @Bean
    @ConditionalOnMissingBean
    public IUserAuthorization getIUserAuthorization() {
        return new DefaultUserAuthorization();
    }

    @Bean
    @ConditionalOnMissingBean
    public IScriptEncrypt getIScriptEncrypt() {
        return new DefaultScriptEncrypt();
    }

    @Bean
    @ConditionalOnMissingBean
    public IApiDocSync getIApiSync() {
        return new DefaultApiDocSync();
    }

    @Bean
    @ConditionalOnMissingBean
    public IApiInfoCache getIApiCache() {
        return new DefaultApiInfoCache();
    }

    @Bean
    @ConditionalOnMissingBean
    public EncryptChangeService getEncryptChangeService() {
        return new EncryptChangeService();
    }

    @Bean
    @ConditionalOnMissingBean
    public LoginService getLoginService() {
        return new LoginService();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiInfoContent getApiInfoContent() {
        return new ApiInfoContent();
    }

    @Bean
    @ConditionalOnMissingBean
    public AssertFunction getAssertFunction() {
        return new AssertFunction();
    }

    @Bean
    @ConditionalOnMissingBean
    public IRequestInterceptor getIRequestInterceptor() {
        return new DefaultRequestInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public IDBCache getDBCache() {
        return new DefaultDBCache();
    }

    @Bean
    @ConditionalOnMissingBean
    public DbFunction getDbFunction() {
        return new DbFunction();
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoFunction getMongoFunction() {
        return new MongoFunction();
    }

    @Bean
    @ConditionalOnMissingBean
    public EnvFunction getEnvFunction() {
        return new EnvFunction();
    }

    @Bean
    @ConditionalOnMissingBean
    public LogFunction getLogFunction() {
        return new LogFunction();
    }

    @Bean
    @ConditionalOnMissingBean
    public PagerFunction getPagerFunction() {
        return new PagerFunction();
    }

    @Bean
    @ConditionalOnMissingBean
    public UtilsFunction getUtilsFunction() {
        return new UtilsFunction();
    }

    @Bean
    @ConditionalOnMissingBean
    public ContextFunction getContextFunction() {
        return new ContextFunction();
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringContextUtils getSpringContextUtils(ApplicationContext applicationContext) {
        return new SpringContextUtils(applicationContext);
    }

    @Bean
    @ConditionalOnProperty(value={"spring.rocket-api.config-enabled"}, havingValue="true")
    public RefreshApiConfig getRefreshApiConfig() {
        return new RefreshApiConfig();
    }

    @Bean
    @ConditionalOnMissingBean
    public ISQLInterceptor getSQLInterceptor() {
        return new DefaultSQLInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public RequestMappingService getRequestMappingService() {
        return new RequestMappingService();
    }

    @Bean
    @ConditionalOnMissingBean
    public CompletionService getCompletionService() {
        return new CompletionService();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConfigService getConfigService() {
        return new ConfigService();
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSourceService getDataSourceService() {
        return new DataSourceService();
    }

    @Bean
    @ConditionalOnMissingBean
    public ApiInfoService getApiInfoService() {
        return new ApiInfoService();
    }

    @Bean
    @ConditionalOnMissingBean
    public ClickHouseDriver getClickHouseDriver() {
        return new ClickHouseDriver();
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoDriver getMongoDriver() {
        return new MongoDriver();
    }

    @Bean
    @ConditionalOnMissingBean
    public MySQLDriver getMySQLDriver() {
        return new MySQLDriver();
    }

    @Bean
    @ConditionalOnMissingBean
    public OracleDriver getOracleDriver() {
        return new OracleDriver();
    }

    @Bean
    @ConditionalOnMissingBean
    public PostgreSQLDriver getPostgreSQLDriver() {
        return new PostgreSQLDriver();
    }

    @Bean
    @ConditionalOnMissingBean
    public SQLServerDriver getSQLServerDriver() {
        return new SQLServerDriver();
    }

    @Bean
    @ConditionalOnMissingBean
    public IClusterNotify getClusterNotify() {
        return new DefaultClusterNotify();
    }
}

