/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.controller;

import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.datasource.DataSourceManager;
import com.github.alenfive.rocketapi.utils.PackageUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"${spring.rocket-api.base-register-path:/interface-ui}"})
@ConditionalOnProperty(name={"spring.rocket-api.view-enabled"}, havingValue="true", matchIfMissing=true)
public class ViewController {
    @Autowired
    private DataSourceManager dataSourceManager;
    @Autowired
    private RocketApiProperties rocketApiProperties;

    @GetMapping
    public String index(Model model, HttpServletRequest request) {
        model.addAttribute("dataSourceList", this.dataSourceManager.getDialectMap().keySet());
        model.addAttribute("service", (Object)this.rocketApiProperties.getServiceName());
        model.addAttribute("title", (Object)this.rocketApiProperties.getServiceTitle());
        model.addAttribute("configEnabled", (Object)this.rocketApiProperties.isConfigEnabled());
        model.addAttribute("version", (Object)PackageUtils.getVersion());
        if (request.getRequestURI().endsWith("/")) {
            return "redirect:" + this.rocketApiProperties.getBaseRegisterPath();
        }
        return "rocketapi/api-index";
    }
}

