/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.datasource;

import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.config.SpringContextUtils;
import com.github.alenfive.rocketapi.entity.ApiEntity;
import com.github.alenfive.rocketapi.entity.vo.Page;
import com.github.alenfive.rocketapi.entity.vo.ScriptContext;
import com.github.alenfive.rocketapi.entity.vo.TableInfo;
import com.github.alenfive.rocketapi.extend.IApiPager;
import com.github.alenfive.rocketapi.utils.FieldUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DataSourceDialect {
    private boolean isDynamic = false;
    protected boolean storeApi = false;

    public boolean isStoreApi() {
        return this.storeApi;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.isDynamic = dynamic;
    }

    public abstract <T extends ApiEntity> void saveEntity(T var1);

    public abstract <T extends ApiEntity> T findEntityById(T var1);

    public abstract <T extends ApiEntity> void removeEntityById(T var1);

    public abstract <T extends ApiEntity> void updateEntityById(T var1);

    public abstract <T extends ApiEntity> List<T> listByEntity(T var1);

    public abstract <T extends ApiEntity> List<T> pageByEntity(T var1, IApiPager var2, Page var3);

    public abstract List<Map<String, Object>> find(ScriptContext var1) throws Exception;

    public abstract int update(ScriptContext var1) throws Exception;

    public abstract int[] batchUpdate(ScriptContext var1) throws Exception;

    public abstract int remove(ScriptContext var1) throws Exception;

    public abstract Object insert(ScriptContext var1) throws Exception;

    protected Map<String, Object> toReplaceKeyLow(Map<String, Object> map) {
        RocketApiProperties properties = (RocketApiProperties)SpringContextUtils.getApplicationContext().getBean(RocketApiProperties.class);
        if (!properties.isMapUnderscoreToCamelCase()) {
            return map;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(map.size());
        for (String key : map.keySet()) {
            result.put(FieldUtils.underlineToCamel(key), map.get(key));
        }
        return result;
    }

    public abstract String buildCountScript(String var1, IApiPager var2, Page var3);

    public abstract String buildPageScript(String var1, IApiPager var2, Page var3);

    public abstract String transcoding(String var1);

    public abstract List<TableInfo> buildTableInfo();

    public abstract void close();
}

