/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.datasource;

import com.github.alenfive.rocketapi.datasource.DataSourceDialect;
import com.github.alenfive.rocketapi.entity.ApiEntity;
import com.github.alenfive.rocketapi.entity.vo.Page;
import com.github.alenfive.rocketapi.entity.vo.ScriptContext;
import com.github.alenfive.rocketapi.entity.vo.TableInfo;
import com.github.alenfive.rocketapi.extend.IApiPager;
import com.github.alenfive.rocketapi.utils.ApiAnnotationUtil;
import com.github.alenfive.rocketapi.utils.FieldUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.CollectionUtils;

public class MongoDataSource
extends DataSourceDialect {
    private MongoTemplate mongoTemplate;

    private MongoDataSource() {
    }

    public MongoDataSource(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    public MongoDataSource(MongoTemplate mongoTemplate, boolean storeApi) {
        this.mongoTemplate = mongoTemplate;
        this.storeApi = storeApi;
    }

    @Override
    public <T extends ApiEntity> void saveEntity(T entity) {
        this.mongoTemplate.save(entity, ApiAnnotationUtil.getApiTableName(entity.getClass()));
    }

    @Override
    public <T extends ApiEntity> T findEntityById(T entity) {
        return (T)((ApiEntity)this.mongoTemplate.findById((Object)entity.getId(), entity.getClass(), ApiAnnotationUtil.getApiTableName(entity.getClass())));
    }

    @Override
    public <T extends ApiEntity> void removeEntityById(T entity) {
        this.mongoTemplate.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(entity.getId()))), ApiAnnotationUtil.getApiTableName(entity.getClass()));
    }

    @Override
    public <T extends ApiEntity> void updateEntityById(T entity) {
        this.mongoTemplate.save(entity, ApiAnnotationUtil.getApiTableName(entity.getClass()));
    }

    @Override
    public <T extends ApiEntity> List<T> listByEntity(T entity) {
        Query query = Query.query((CriteriaDefinition)this.buildCriteria(entity));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoTemplate.find(query, entity.getClass(), ApiAnnotationUtil.getApiTableName(entity.getClass()));
    }

    private <T extends ApiEntity> Criteria buildCriteria(T entity) {
        Criteria criteria = new Criteria();
        FieldUtils.allFields(entity.getClass()).stream().filter(item -> {
            item.setAccessible(true);
            try {
                Object value = item.get(entity);
                return value != null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return false;
            }
        }).forEach(item -> {
            try {
                criteria.and(item.getName()).is(item.get(entity));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        return criteria;
    }

    @Override
    public <T extends ApiEntity> List<T> pageByEntity(T entity, IApiPager apiPager, Page page) {
        Query query = Query.query((CriteriaDefinition)this.buildCriteria(entity));
        query.skip((long)apiPager.getOffset(page.getPageSize(), page.getPageNo()).intValue()).limit(page.getPageSize().intValue());
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        return this.mongoTemplate.find(query, entity.getClass(), ApiAnnotationUtil.getApiTableName(entity.getClass()));
    }

    @Override
    public List<Map<String, Object>> find(ScriptContext scriptContext) throws Exception {
        this.formatISODate(scriptContext.getScript());
        this.formatObjectIdList(scriptContext.getScript());
        Document document = this.mongoTemplate.executeCommand(scriptContext.getScript().toString());
        if (document.get((Object)"n") != null) {
            HashMap<String, Object> count = new HashMap<String, Object>();
            count.put("count", document.get((Object)"n"));
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(1);
            result.add(count);
            return result;
        }
        Document cursor = (Document)document.get((Object)"cursor");
        if (cursor != null) {
            List documents = (List)cursor.get((Object)"firstBatch");
            while (Long.valueOf(cursor.get((Object)"id").toString()) > 0L) {
                Document more = new Document();
                more.put("getMore", cursor.get((Object)"id"));
                more.put("collection", (Object)cursor.get((Object)"ns").toString().split("\\.")[1]);
                document = this.mongoTemplate.executeCommand(more);
                cursor = (Document)document.get((Object)"cursor");
                documents.addAll((List)cursor.get((Object)"nextBatch"));
            }
            return documents.stream().map(item -> this.toMap((Document)item)).collect(Collectors.toList());
        }
        return Arrays.asList(this.toMap(document));
    }

    @Override
    public int update(ScriptContext scriptContext) throws Exception {
        this.formatISODate(scriptContext.getScript());
        this.formatObjectIdList(scriptContext.getScript());
        Document result = this.mongoTemplate.executeCommand(scriptContext.getScript().toString());
        return result.getInteger((Object)"n");
    }

    @Override
    public int[] batchUpdate(ScriptContext scriptContext) throws Exception {
        return new int[0];
    }

    @Override
    public int remove(ScriptContext scriptContext) throws Exception {
        this.formatISODate(scriptContext.getScript());
        this.formatObjectIdList(scriptContext.getScript());
        Document result = this.mongoTemplate.executeCommand(scriptContext.getScript().toString());
        return result.getInteger((Object)"n");
    }

    @Override
    public Object insert(ScriptContext scriptContext) throws Exception {
        this.formatISODate(scriptContext.getScript());
        this.formatObjectIdList(scriptContext.getScript());
        return this.batchInsert(scriptContext.getScript()).get(0).toString();
    }

    private List<Object> batchInsert(StringBuilder script) {
        Document insertDoc = Document.parse((String)script.toString());
        List<Document> docList = this.getList(insertDoc, "documents", Document.class, null);
        if (CollectionUtils.isEmpty(docList)) {
            throw new RuntimeException("insert documents is empty");
        }
        for (Document doc : docList) {
            ObjectId id = doc.getObjectId((Object)"_id");
            if (id != null) continue;
            doc.put("_id", (Object)ObjectId.get());
        }
        this.mongoTemplate.executeCommand(insertDoc);
        return docList.stream().map(item -> item.get((Object)"_id")).collect(Collectors.toList());
    }

    private <T> List<T> getList(Document document, Object key, Class<T> clazz, List<T> defaultValue) {
        List value = (List)document.get(key, List.class);
        if (value == null) {
            return defaultValue;
        }
        for (Object item : value) {
            if (clazz.isAssignableFrom(item.getClass())) continue;
            throw new ClassCastException(String.format("List element cannot be cast to %s", clazz.getName()));
        }
        return value;
    }

    private void formatObjectIdList(StringBuilder script) {
        int startIndex;
        String flag = "ObjectId(";
        for (int i = 0; i < script.length() && (startIndex = script.indexOf(flag, i)) != -1; ++i) {
            int endIndex = script.indexOf(")", startIndex + flag.length());
            if (endIndex == -1) {
                throw new IllegalArgumentException("missed ObjectId( close ')'");
            }
            String objectIdStr = script.substring(startIndex + flag.length(), endIndex);
            String[] objectIdArr = objectIdStr.split(",");
            if (objectIdArr.length == 1) {
                i = endIndex;
                continue;
            }
            String newObjectIds = Stream.of(objectIdArr).map(item -> "ObjectId(" + item + ")").collect(Collectors.joining(","));
            i = startIndex + newObjectIds.length();
            script = script.replace(startIndex, endIndex + 1, newObjectIds);
        }
    }

    public void formatISODate(StringBuilder script) {
        int startIndex;
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdfUtc = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        String flag = "ISODate(";
        for (int i = 0; i < script.length() && (startIndex = script.indexOf(flag, i)) != -1; ++i) {
            int endIndex = script.indexOf(")", startIndex + flag.length());
            if (endIndex == -1) {
                throw new IllegalArgumentException("missed ISODate( close ')'");
            }
            String timeStr = script.substring(startIndex + flag.length() + 1, endIndex - 1);
            try {
                sdfUtc.parse(timeStr);
                i = endIndex;
                continue;
            }
            catch (ParseException parseException) {
                boolean isLocal = timeStr.endsWith("+08:00");
                if (isLocal) {
                    timeStr = timeStr.replace("+08:00", "").replace("T", " ");
                }
                Date time = null;
                try {
                    time = sdf1.parse(timeStr);
                }
                catch (ParseException e) {
                    try {
                        time = sdf2.parse(timeStr);
                    }
                    catch (ParseException ex) {
                        try {
                            time = sdf3.parse(timeStr);
                        }
                        catch (ParseException exx) {
                            throw new MissingFormatArgumentException("format ISODate error " + script.substring(startIndex, endIndex));
                        }
                    }
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(time);
                calendar.add(11, -8);
                String newTime = sdfUtc.format(calendar.getTime());
                i = startIndex + flag.length() + 1 + newTime.length();
                script = script.replace(startIndex + flag.length() + 1, endIndex - 1, newTime);
            }
        }
    }

    private Map<String, Object> toMap(Document item) {
        HashMap<String, Object> map = new HashMap<String, Object>(item.size());
        Set keys = item.keySet();
        for (String key : keys) {
            Object value = item.get((Object)key);
            if ("_id".equals(key)) {
                key = "id";
            }
            if (value instanceof Document) {
                map.put(key, this.toMap((Document)value));
                continue;
            }
            map.put(key, value instanceof ObjectId ? ((ObjectId)value).toHexString() : value);
        }
        return map;
    }

    @Override
    public String buildCountScript(String script, IApiPager apiPager, Page page) {
        Document document = Document.parse((String)script);
        document.put("count", document.get((Object)"find"));
        document.put("query", document.get((Object)"filter"));
        document.remove((Object)"find");
        document.remove((Object)"filter");
        document.remove((Object)"sort");
        return document.toJson();
    }

    @Override
    public String buildPageScript(String script, IApiPager apiPager, Page page) {
        Document document = Document.parse((String)script);
        document.put("skip", (Object)apiPager.getOffset(page.getPageSize(), page.getPageNo()));
        document.put("limit", (Object)page.getPageSize());
        return document.toJson();
    }

    @Override
    public String transcoding(String param) {
        return param.replace("\\", "\\\\").replace("\"", "\\\"").replace("'", "\\'");
    }

    @Override
    public void close() {
    }

    @Override
    public List<TableInfo> buildTableInfo() {
        return null;
    }
}

