/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.extend;

import com.github.alenfive.rocketapi.config.SpringContextUtils;
import com.github.alenfive.rocketapi.entity.ApiInfo;
import com.github.alenfive.rocketapi.extend.IApiInfoCache;
import com.github.alenfive.rocketapi.utils.RequestUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public abstract class ApiInfoInterceptor
implements HandlerInterceptor {
    private ApiInfo getApiInfo(HttpServletRequest request) {
        String pattern = RequestUtils.buildPattern(request);
        if (pattern == null) {
            return null;
        }
        IApiInfoCache apiInfoCache = (IApiInfoCache)SpringContextUtils.getApplicationContext().getBean(IApiInfoCache.class);
        String method = request.getMethod();
        return apiInfoCache.get(ApiInfo.builder().fullPath(pattern).method(method).build());
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        ApiInfo apiInfo = this.getApiInfo(request);
        if (apiInfo == null) {
            return true;
        }
        return this.preHandle(request, response, handler, apiInfo);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        ApiInfo apiInfo = this.getApiInfo(request);
        if (apiInfo == null) {
            return;
        }
        this.postHandle(request, response, handler, modelAndView, apiInfo);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    public abstract boolean preHandle(HttpServletRequest var1, HttpServletResponse var2, Object var3, ApiInfo var4);

    public abstract void postHandle(HttpServletRequest var1, HttpServletResponse var2, Object var3, ModelAndView var4, ApiInfo var5);
}

