/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.extend;

import com.github.alenfive.rocketapi.entity.LRUHashMap;
import com.github.alenfive.rocketapi.extend.IDBCache;
import java.util.HashMap;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultDBCache
implements IDBCache {
    private static final Logger log = LoggerFactory.getLogger(DefaultDBCache.class);
    private Integer maxCacheSize = 1024;
    private Timer timer = new Timer();
    private static final long CHECK_TIME_SECOND = 10000L;
    private LRUHashMap<String, Object> cacheMap = new LRUHashMap(this.maxCacheSize);
    private HashMap<String, Long> expiresTime = new HashMap();
    private TimerTask timerTask = new TimerTask(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set keys = DefaultDBCache.this.expiresTime.keySet();
            for (String key : keys) {
                if ((Long)DefaultDBCache.this.expiresTime.get(key) > System.currentTimeMillis()) continue;
                1 var4_4 = this;
                synchronized (var4_4) {
                    DefaultDBCache.this.expiresTime.remove(key);
                    DefaultDBCache.this.cacheMap.remove(key);
                    log.debug("Automatic cache expiration:{}", (Object)key);
                }
            }
        }
    };

    @PostConstruct
    public void init() {
        this.timer.schedule(this.timerTask, 10000L, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String cacheKey, Object value, Long cacheTime) {
        DefaultDBCache defaultDBCache = this;
        synchronized (defaultDBCache) {
            this.cacheMap.put((String)cacheKey, (Object)value);
            this.expiresTime.put(cacheKey, System.currentTimeMillis() + cacheTime);
        }
    }

    @Override
    public Object get(String cacheKey) {
        return this.cacheMap.get(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String cacheKey) {
        DefaultDBCache defaultDBCache = this;
        synchronized (defaultDBCache) {
            this.cacheMap.remove(cacheKey);
            this.expiresTime.remove(cacheKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        DefaultDBCache defaultDBCache = this;
        synchronized (defaultDBCache) {
            this.cacheMap.clear();
            this.expiresTime.clear();
        }
    }
}

