/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.extend;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.alenfive.rocketapi.config.QLRequestMappingFactory;
import com.github.alenfive.rocketapi.config.RocketApiProperties;
import com.github.alenfive.rocketapi.entity.vo.NotifyEntity;
import com.github.alenfive.rocketapi.entity.vo.NotifyEventType;
import com.github.alenfive.rocketapi.extend.IClusterNotify;
import com.github.alenfive.rocketapi.service.ApiInfoService;
import com.github.alenfive.rocketapi.service.ConfigService;
import com.github.alenfive.rocketapi.service.DataSourceService;
import com.github.alenfive.rocketapi.utils.GenerateId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisClusterNotify
implements IClusterNotify,
MessageListener {
    private String instanceId = GenerateId.get().toHexString();
    @Autowired
    private ApiInfoService apiInfoService;
    @Autowired
    private QLRequestMappingFactory mappingFactory;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private RocketApiProperties rocketApiProperties;
    @Autowired
    private ConfigService configService;

    public String buildChannelName() {
        return "rocket-api:" + this.rocketApiProperties.getServiceName() + ":channel";
    }

    @Override
    public void sendNotify(NotifyEntity notifyEntity) {
        notifyEntity.setInstanceId(this.instanceId);
        String messageStr = null;
        try {
            messageStr = this.objectMapper.writeValueAsString((Object)notifyEntity);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        this.redisTemplate.convertAndSend(this.buildChannelName(), (Object)messageStr);
    }

    @Override
    public void receiveNotify(NotifyEntity notifyEntity) {
        if (this.instanceId.equals(notifyEntity.getInstanceId())) {
            return;
        }
        if (NotifyEventType.ReInit.equals((Object)notifyEntity.getEventType())) {
            try {
                this.mappingFactory.reInit(false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (NotifyEventType.RefreshMapping.equals((Object)notifyEntity.getEventType())) {
            try {
                this.apiInfoService.refreshMapping(notifyEntity.getRefreshMapping());
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            return;
        }
        if (NotifyEventType.RefreshDB.equals((Object)notifyEntity.getEventType())) {
            try {
                this.dataSourceService.refreshDB(notifyEntity.getRefreshDB());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (NotifyEventType.RefreshConfig.equals((Object)notifyEntity.getEventType())) {
            this.configService.refreshConfig();
        }
    }

    public void onMessage(Message message, byte[] bytes) {
        String messageStr = new String(message.getBody());
        NotifyEntity notifyEntity = null;
        try {
            notifyEntity = (NotifyEntity)this.objectMapper.readValue(messageStr, NotifyEntity.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.receiveNotify(notifyEntity);
    }
}

