/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.function;

import com.github.alenfive.rocketapi.extend.ApiInfoContent;
import com.github.alenfive.rocketapi.function.IFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogFunction
implements IFunction {
    private static final Logger log = LoggerFactory.getLogger(LogFunction.class);
    @Autowired
    private ApiInfoContent apiInfoContent;

    @Override
    public String getVarName() {
        return "log";
    }

    public void info(Object format, Object ... args) {
        log.info(format.toString(), args);
        this.apiInfoContent.putLog("info:" + MessageFormatter.arrayFormat((String)format.toString(), (Object[])args).getMessage());
    }

    public void debug(Object format, Object ... args) {
        log.debug(format.toString(), args);
        this.apiInfoContent.putLog("debug: " + MessageFormatter.arrayFormat((String)format.toString(), (Object[])args).getMessage());
    }

    public void error(Object format, Object ... args) {
        log.error(format.toString(), args);
        this.apiInfoContent.putLog("error: " + MessageFormatter.arrayFormat((String)format.toString(), (Object[])args).getMessage());
    }

    public void warn(Object format, Object ... args) {
        log.warn(format.toString(), args);
        this.apiInfoContent.putLog("warn: " + MessageFormatter.arrayFormat((String)format.toString(), (Object[])args).getMessage());
    }

    public void trace(Object format, Object ... args) {
        log.trace(format.toString(), args);
        this.apiInfoContent.putLog("trace: " + MessageFormatter.arrayFormat((String)format.toString(), (Object[])args).getMessage());
    }
}

