/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.alenfive.rocketapi.datasource.DataSourceDialect;
import com.github.alenfive.rocketapi.datasource.JdbcDataSource;
import com.github.alenfive.rocketapi.entity.ApiParams;
import com.github.alenfive.rocketapi.entity.ParamScope;
import com.github.alenfive.rocketapi.entity.vo.ArrVar;
import com.github.alenfive.rocketapi.entity.vo.ConditionMatcher;
import com.github.alenfive.rocketapi.entity.vo.ScriptLanguageParam;
import com.github.alenfive.rocketapi.extend.ApiInfoContent;
import com.github.alenfive.rocketapi.script.IScriptParse;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Types;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ScriptParseService {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    @Lazy
    private IScriptParse scriptParse;
    @Autowired
    private ApiInfoContent apiInfoContent;
    private Set<String> scopeSet = Stream.of(ParamScope.values()).map(Enum::name).collect(Collectors.toSet());
    private Pattern sqlTypePattern = null;

    public ScriptParseService() {
        Field[] fields = Types.class.getFields();
        StringBuilder typeMatcherStr = new StringBuilder(",\\s*(");
        typeMatcherStr.append(Arrays.stream(fields).map(item -> item.getName()).collect(Collectors.joining("|")));
        typeMatcherStr.append(")\\s*$");
        this.sqlTypePattern = Pattern.compile(",\\s*\\w+\\s*$");
    }

    public Map<String, Object> parse(StringBuilder script, DataSourceDialect sourceDialect, Map<String, Object> specifyParams) {
        this.buildIf(script, specifyParams);
        return this.buildParams(script, sourceDialect, specifyParams);
    }

    public void buildIf(StringBuilder script, Map<String, Object> specifyParams) {
        int startIf;
        String flag = "?{";
        while ((startIf = script.indexOf(flag)) != -1) {
            int ifSplitIndex = -1;
            int ifCloseIndex = -1;
            int quotationMark = 0;
            int bigBracket = 1;
            int roundBracket = 0;
            int squareBracket = 0;
            for (int i = startIf + flag.length(); i < script.length(); ++i) {
                char c = script.charAt(i);
                if (quotationMark > 0) {
                    if (c == '\\') {
                        ++i;
                        continue;
                    }
                    if (c != '\"') continue;
                    --quotationMark;
                    continue;
                }
                if (c == '\"') {
                    ++quotationMark;
                    continue;
                }
                if (c == '{') {
                    ++bigBracket;
                }
                if (c == '(') {
                    ++roundBracket;
                }
                if (c == '[') {
                    ++squareBracket;
                }
                if (c == '}') {
                    --bigBracket;
                }
                if (c == ')') {
                    --roundBracket;
                }
                if (c == ']') {
                    --squareBracket;
                }
                if (ifSplitIndex == -1 && c == ',' && bigBracket == 1 && roundBracket == 0 && squareBracket == 0) {
                    ifSplitIndex = i;
                }
                if (c != '}' || bigBracket != 0) continue;
                ifCloseIndex = i;
                break;
            }
            if (ifCloseIndex == -1) {
                throw new IllegalArgumentException("missed if close '}'");
            }
            if (ifSplitIndex == -1) {
                throw new IllegalArgumentException("missed if split ','");
            }
            String condition = script.substring(startIf + flag.length(), ifSplitIndex).trim();
            Object value = this.buildContentScopeParamItem(specifyParams, condition);
            if (StringUtils.isEmpty((Object)value) || value instanceof Boolean && !((Boolean)value).booleanValue()) {
                script = script.replace(startIf, ifCloseIndex + 1, "");
                continue;
            }
            script = script.replace(startIf, ifCloseIndex + 1, script.substring(ifSplitIndex + 1, ifCloseIndex));
        }
    }

    public Map<String, Object> buildParams(StringBuilder script, DataSourceDialect sourceDialect, Map<String, Object> specifyParams) {
        HashMap<String, ScriptLanguageParam> paramKeys = new HashMap<String, ScriptLanguageParam>();
        AtomicInteger atomicInteger = new AtomicInteger();
        int start = 0;
        Pattern pattern = Pattern.compile(":[a-z_\\-A-Z0-9]+");
        Matcher parameterMatcher = pattern.matcher(script);
        while (parameterMatcher.find(start)) {
            String replaceValue = parameterMatcher.group();
            String parameter = this.buildParamKey(atomicInteger);
            ScriptLanguageParam languageParam = ScriptLanguageParam.builder().scriptLanguage(replaceValue.substring(1)).build();
            paramKeys.put(parameter, languageParam);
            start = parameterMatcher.start() + replaceValue.length();
        }
        start = 0;
        ConditionMatcher matcher = null;
        while ((matcher = this.buildParamCondition(script, "#{", start)) != null) {
            ScriptLanguageParam languageParam = this.buildScriptLanguageParam(matcher.getCondition());
            String parameter = this.buildParamKey(atomicInteger);
            paramKeys.put(parameter, languageParam);
            String replaceValue = null;
            if (sourceDialect instanceof JdbcDataSource) {
                replaceValue = ":" + parameter;
            } else {
                Object value = this.buildContentScopeParamItem(specifyParams, languageParam.getScriptLanguage());
                replaceValue = this.buildValue(value, sourceDialect);
                if (replaceValue == null) {
                    replaceValue = "null";
                }
            }
            script = script.replace(matcher.getStart(), matcher.getEnd() + 1, replaceValue);
            start = matcher.getStart() + replaceValue.length();
        }
        start = 0;
        while ((matcher = this.buildParamCondition(script, "${", start)) != null) {
            Object value = this.buildContentScopeParamItem(specifyParams, matcher.getCondition());
            String replaceValue = this.buildSourceValue(value);
            if (replaceValue == null) {
                replaceValue = "null";
            }
            script = script.replace(matcher.getStart(), matcher.getEnd() + 1, replaceValue);
            start = matcher.getStart() + replaceValue.length();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (String parameter : paramKeys.keySet()) {
            ScriptLanguageParam languageParam = (ScriptLanguageParam)paramKeys.get(parameter);
            Object value = this.buildContentScopeParamItem(specifyParams, languageParam.getScriptLanguage());
            if (languageParam.getSqlType() != null) {
                params.put(parameter, new SqlParameterValue(languageParam.getSqlType().intValue(), value));
                continue;
            }
            params.put(parameter, value);
        }
        return params;
    }

    private String buildParamKey(AtomicInteger atomicInteger) {
        return "param" + atomicInteger.getAndIncrement();
    }

    private ScriptLanguageParam buildScriptLanguageParam(String condition) {
        Integer sqlType = null;
        String scriptLanguage = null;
        Matcher matcher = this.sqlTypePattern.matcher(condition);
        if (matcher.find()) {
            String typeFieldName = matcher.group().substring(1).trim();
            try {
                Field field = Types.class.getField(typeFieldName);
                field.setAccessible(true);
                sqlType = (Integer)field.get(null);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("NoSuchField java.sql.Types." + typeFieldName + "");
            }
            scriptLanguage = condition.substring(0, matcher.start());
        } else {
            scriptLanguage = condition;
        }
        return ScriptLanguageParam.builder().sqlType(sqlType).scriptLanguage(scriptLanguage).build();
    }

    private ConditionMatcher buildParamCondition(StringBuilder script, String flag, int start) {
        int startIf = script.indexOf(flag, start);
        if (startIf == -1) {
            return null;
        }
        int ifCloseIndex = -1;
        int quotationMark = 0;
        int bigBracket = 1;
        for (int i = startIf + flag.length(); i < script.length(); ++i) {
            char c = script.charAt(i);
            if (quotationMark > 0) {
                if (c == '\\') {
                    ++i;
                    continue;
                }
                if (c != '\"') continue;
                --quotationMark;
                continue;
            }
            if (c == '\"') {
                ++quotationMark;
                continue;
            }
            if (c == '{') {
                ++bigBracket;
            }
            if (c == '}') {
                --bigBracket;
            }
            if (c != '}' || bigBracket != 0) continue;
            ifCloseIndex = i;
            break;
        }
        if (ifCloseIndex == -1) {
            throw new IllegalArgumentException("missed if close '}'");
        }
        return ConditionMatcher.builder().condition(script.substring(startIf + flag.length(), ifCloseIndex)).start(startIf).end(ifCloseIndex).build();
    }

    public Object buildRequestScopeParamItem(ApiParams apiParams, Map<String, Object> specifyParams, String varName) {
        String[] paramArr = varName.split("\\.");
        if (specifyParams != null) {
            return this.buildObjectValue(specifyParams, paramArr, 0, varName);
        }
        Object value = null;
        if (this.scopeSet.contains(paramArr[0])) {
            switch (ParamScope.valueOf(paramArr[0])) {
                case _pathVar: {
                    value = this.buildValueOfPathVar(apiParams.getPathVar(), paramArr[1]);
                    break;
                }
                case _param: {
                    value = this.buildValueOfParameter(apiParams.getParam(), paramArr, 1);
                    break;
                }
                case _body: {
                    value = this.buildValueOfBody(apiParams.getBody(), paramArr, 1);
                    break;
                }
                case _cookie: {
                    value = this.buildValueOfCookie(apiParams.getCookie(), apiParams.getRequest(), paramArr, 1);
                    break;
                }
                case _header: {
                    value = this.buildValueOfHeader(apiParams.getHeader(), paramArr, 1);
                    break;
                }
                case _session: {
                    value = this.buildValueOfSession(apiParams.getSession(), paramArr, 1);
                }
            }
        } else {
            value = this.buildValueOfScriptContent(this.apiInfoContent.getEngineBindings() == null ? null : this.apiInfoContent.getEngineBindings(), paramArr, 0);
            if (value == null) {
                value = this.buildValueOfPathVar(apiParams.getPathVar(), paramArr[0]);
            }
            if (value == null) {
                value = this.buildValueOfParameter(apiParams.getParam(), paramArr, 0);
            }
            if (value == null) {
                value = this.buildValueOfBody(apiParams.getBody(), paramArr, 0);
            }
            if (value == null) {
                value = this.buildValueOfCookie(apiParams.getCookie(), apiParams.getRequest(), paramArr, 0);
            }
            if (value == null) {
                value = this.buildValueOfHeader(apiParams.getHeader(), paramArr, 0);
            }
            if (value == null) {
                value = this.buildValueOfSession(apiParams.getSession(), paramArr, 0);
            }
        }
        return value;
    }

    public Object buildContentScopeParamItem(Map<String, Object> specifyParams, String scriptLanguage) {
        Bindings bindings = specifyParams != null ? new SimpleBindings(specifyParams) : this.apiInfoContent.getEngineBindings();
        Object value = null;
        try {
            value = Pattern.matches("^\\w+$", scriptLanguage) ? bindings.get(scriptLanguage) : this.scriptParse.engineEval(scriptLanguage, bindings);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (value != null && value.getClass().isArray()) {
            value = Arrays.asList((String[])value);
        }
        return value;
    }

    private Object buildValueOfScriptContent(Bindings bindings, String[] paramArr, int index) {
        if (bindings == null) {
            return null;
        }
        return this.buildObjectValue(bindings, paramArr, index, paramArr[index]);
    }

    public Object buildValueOfSession(Map<String, Object> session, String[] paramArr, int index) {
        if (session == null) {
            return null;
        }
        return this.buildObjectValue(session, paramArr, index, paramArr[index]);
    }

    private Object buildValueOfHeader(Map<String, String> header, String[] paramArr, int index) {
        String varName = paramArr[index].toLowerCase();
        if (header == null) {
            return null;
        }
        return this.buildObjectValue(header, paramArr, index, varName);
    }

    private Object buildValueOfCookie(Map<String, Object> cookie, HttpServletRequest request, String[] paramArr, int index) {
        String varName = paramArr[index];
        Object value = null;
        if (cookie != null) {
            value = cookie.get(varName);
        }
        if (request != null && value == null) {
            Cookie[] cookies = request.getCookies();
            if (cookies == null) {
                return null;
            }
            for (Cookie item : cookies) {
                if (!item.getName().equals(varName)) continue;
                value = item.getValue();
                break;
            }
        }
        if (paramArr.length - 1 > index) {
            return this.buildObjectValue(value, paramArr, index + 1, paramArr[index + 1]);
        }
        return value;
    }

    private Object buildValueOfBody(Map<String, Object> body, String[] paramArr, int index) {
        if (body == null) {
            return null;
        }
        return this.buildObjectValue(body, paramArr, index, paramArr[index]);
    }

    private Object buildValueOfParameter(Map<String, Object> params, String[] paramArr, int index) {
        if (params == null) {
            return null;
        }
        return this.buildObjectValue(params, paramArr, index, paramArr[index]);
    }

    private Object buildObjectValue(Object inputParam, String[] paramArr, int index, String varName) {
        if (inputParam == null) {
            return null;
        }
        Map params = null;
        if (inputParam instanceof Map) {
            params = (Map)inputParam;
        } else {
            if (inputParam instanceof String) {
                try {
                    params = (Map)this.objectMapper.readValue(inputParam.toString(), Map.class);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(inputParam + " Cannot be cast to Map.class");
                }
            }
            try {
                params = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsBytes(inputParam), Map.class);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(inputParam + "Cannot be cast to Map.class");
            }
        }
        Object value = null;
        ArrVar arrVar = this.isArrVar(varName);
        if (arrVar != null) {
            Object collection = params.get(arrVar.getVarName());
            if (collection == null) {
                throw new IllegalArgumentException("The " + arrVar.getVarName() + " parameter is null");
            }
            if (!(collection instanceof Collection)) {
                throw new IllegalArgumentException("The " + arrVar.getVarName() + " parameter is not an array");
            }
            Collection list = (Collection)collection;
            if (arrVar.getIndex() >= list.size()) {
                throw new IllegalArgumentException("The parameter " + arrVar.getVarName() + " exceeds the array length");
            }
            value = list.toArray()[arrVar.getIndex()];
        } else {
            value = params.get(varName);
        }
        if (paramArr.length - 1 > index) {
            return this.buildObjectValue(value, paramArr, index + 1, paramArr[index + 1]);
        }
        return value;
    }

    private ArrVar isArrVar(String varName) {
        boolean isArrVar = varName.matches(".+\\[\\d+\\]$");
        if (!isArrVar) {
            return null;
        }
        String varNameFinal = varName.substring(0, varName.indexOf("["));
        Integer index = Integer.valueOf(varName.substring(varName.indexOf("[") + 1, varName.length() - 1));
        return new ArrVar(varNameFinal, index);
    }

    private Object buildValueOfPathVar(Map<String, String> pathVars, String varName) {
        if (pathVars == null) {
            return null;
        }
        return pathVars.get(varName);
    }

    private String buildSourceValue(Object val) {
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    public String buildValue(Object val, DataSourceDialect sourceDialect) {
        if (val == null) {
            return null;
        }
        StringBuilder valStr = new StringBuilder();
        if (val instanceof Collection) {
            valStr.append((Object)((Collection)val).stream().map(item -> this.buildStrValue(item, sourceDialect)).collect(Collectors.joining(",")));
        } else {
            valStr.append(this.buildStrValue(val, sourceDialect));
        }
        return valStr.toString();
    }

    public String buildFormatValue(Object val, DataSourceDialect sourceDialect) {
        if (val == null) {
            return "null";
        }
        StringBuilder valStr = new StringBuilder();
        if (val instanceof Collection) {
            valStr.append((Object)((Collection)val).stream().map(item -> this.buildStrValue(item, sourceDialect)).collect(Collectors.joining(",")));
        } else {
            valStr.append(this.buildStrValue(val, sourceDialect));
        }
        return valStr.toString();
    }

    private String buildStrValue(Object val, DataSourceDialect sourceDialect) {
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return val.toString();
        }
        if (val instanceof Boolean) {
            return val.toString();
        }
        return "'" + this.transcoding(val.toString(), sourceDialect) + "'";
    }

    public String transcoding(String input, DataSourceDialect sourceDialect) {
        if (sourceDialect == null) {
            return input;
        }
        return sourceDialect.transcoding(input);
    }
}

