/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.utils;

import com.github.alenfive.rocketapi.datasource.DataSourceDialect;
import com.github.alenfive.rocketapi.entity.vo.Page;
import com.github.alenfive.rocketapi.extend.IApiPager;
import com.github.alenfive.rocketapi.utils.ApiAnnotationUtil;
import com.github.alenfive.rocketapi.utils.FieldUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.CollectionUtils;

public class ApiJpaUtil {
    private static final Logger log = LoggerFactory.getLogger(ApiJpaUtil.class);
    private static Map<String, String> apiJpaCache = new ConcurrentHashMap<String, String>();

    public static void insert(NamedParameterJdbcTemplate jdbcTemplate, Object apiObject) {
        String tableName = ApiAnnotationUtil.getApiTableName(apiObject.getClass());
        String key = "insert:" + tableName;
        String sql = null;
        sql = apiJpaCache.get(key);
        if (sql == null) {
            sql = "insert into " + tableName + "(" + String.join((CharSequence)",", FieldUtils.allTableFields(apiObject.getClass())) + ")values(" + String.join((CharSequence)",", FieldUtils.allNameParamsFields(apiObject.getClass())) + ")";
        }
        BeanPropertySqlParameterSource parameterSource = new BeanPropertySqlParameterSource(apiObject);
        log.debug("generate script:{}", (Object)sql);
        jdbcTemplate.update(sql, (SqlParameterSource)parameterSource);
    }

    public static <T> List<T> listByEntity(NamedParameterJdbcTemplate jdbcTemplate, T apiObject) {
        String tableName = ApiAnnotationUtil.getApiTableName(apiObject.getClass());
        String where = FieldUtils.allFields(apiObject.getClass()).stream().filter(item -> {
            item.setAccessible(true);
            try {
                Object value = item.get(apiObject);
                return value != null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return false;
            }
        }).map(item -> FieldUtils.humpToLine2(item.getName()) + "=:" + item.getName()).collect(Collectors.joining(" and "));
        String sql = "select " + String.join((CharSequence)",", FieldUtils.allTableFields(apiObject.getClass())) + " from " + tableName + (where == null ? "" : " where " + where);
        BeanPropertySqlParameterSource parameterSource = new BeanPropertySqlParameterSource(apiObject);
        log.debug("generate script:{}", (Object)sql);
        return jdbcTemplate.query(sql, (SqlParameterSource)parameterSource, (RowMapper)new BeanPropertyRowMapper(apiObject.getClass()));
    }

    public static <T> void deleteById(NamedParameterJdbcTemplate jdbcTemplate, T apiObject) {
        String tableName = ApiAnnotationUtil.getApiTableName(apiObject.getClass());
        String idField = ApiAnnotationUtil.getApiIdFieldName(apiObject.getClass());
        String key = "deleteById:" + tableName;
        String sql = null;
        sql = apiJpaCache.get(key);
        if (sql == null) {
            sql = "delete from " + tableName + " where " + idField + " = :" + idField;
        }
        BeanPropertySqlParameterSource parameterSource = new BeanPropertySqlParameterSource(apiObject);
        log.debug("generate script:{}", (Object)sql);
        jdbcTemplate.update(sql, (SqlParameterSource)parameterSource);
    }

    public static <T> T findById(NamedParameterJdbcTemplate jdbcTemplate, T apiObject) {
        String tableName = ApiAnnotationUtil.getApiTableName(apiObject.getClass());
        String idField = ApiAnnotationUtil.getApiIdFieldName(apiObject.getClass());
        String key = "findById:" + tableName;
        String sql = null;
        sql = apiJpaCache.get(key);
        if (sql == null) {
            sql = "select " + String.join((CharSequence)",", FieldUtils.allTableFields(apiObject.getClass())) + " from " + tableName + " where " + idField + " = :" + idField;
        }
        BeanPropertySqlParameterSource parameterSource = new BeanPropertySqlParameterSource(apiObject);
        log.debug("generate script:{}", (Object)sql);
        List apiInfos = jdbcTemplate.query(sql, (SqlParameterSource)parameterSource, (RowMapper)new BeanPropertyRowMapper(apiObject.getClass()));
        if (CollectionUtils.isEmpty((Collection)apiInfos)) {
            return null;
        }
        return (T)apiInfos.get(0);
    }

    public static <T> void updateById(NamedParameterJdbcTemplate jdbcTemplate, T apiObject) {
        String tableName = ApiAnnotationUtil.getApiTableName(apiObject.getClass());
        String idField = ApiAnnotationUtil.getApiIdFieldName(apiObject.getClass());
        String key = "updateById:" + tableName;
        String sql = null;
        sql = apiJpaCache.get(key);
        if (sql == null) {
            sql = "update " + tableName + " set " + String.join((CharSequence)",", FieldUtils.allTableFields(apiObject.getClass()).stream().filter(item -> !item.equals(idField)).map(item -> item + "=:" + FieldUtils.underlineToCamel(item)).collect(Collectors.toList())) + " where " + idField + " = :" + idField;
        }
        BeanPropertySqlParameterSource parameterSource = new BeanPropertySqlParameterSource(apiObject);
        log.debug("generate script:{}", (Object)sql);
        jdbcTemplate.update(sql, (SqlParameterSource)parameterSource);
    }

    public static <T> List<T> pageByEntity(NamedParameterJdbcTemplate jdbcTemplate, T apiObject, DataSourceDialect sqlDataSource, IApiPager apiPager, Page page) {
        String tableName = ApiAnnotationUtil.getApiTableName(apiObject.getClass());
        String where = FieldUtils.allFields(apiObject.getClass()).stream().filter(item -> {
            item.setAccessible(true);
            try {
                Object value = item.get(apiObject);
                return value != null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return false;
            }
        }).map(item -> FieldUtils.humpToLine2(item.getName()) + "=:" + item.getName()).collect(Collectors.joining(" and "));
        String sql = "select " + String.join((CharSequence)",", FieldUtils.allTableFields(apiObject.getClass())) + " from " + tableName + (where == null ? "" : " where " + where) + " order by id desc ";
        sql = sqlDataSource.buildPageScript(sql, apiPager, page);
        log.debug("generate script:{}", (Object)sql);
        BeanPropertySqlParameterSource parameterSource = new BeanPropertySqlParameterSource(apiObject);
        return jdbcTemplate.query(sql, (SqlParameterSource)parameterSource, (RowMapper)new BeanPropertyRowMapper(apiObject.getClass()));
    }
}

