/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CsvUtils {
    public static ByteArrayInputStream writeCsv(Map<String, String> title, List<Map<String, Object>> list) throws UnsupportedEncodingException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sb = new StringBuilder();
        sb.append(title.values().stream().collect(Collectors.joining(", "))).append("\r\n");
        Set<String> titleKeys = title.keySet();
        for (Map<String, Object> info : list) {
            for (String key : titleKeys) {
                Object valObj = info.get(key);
                String valStr = null;
                valStr = valObj instanceof Date ? (valObj == null ? "" : sdf.format(valObj)) : (valObj == null ? "" : valObj.toString());
                valStr = valStr.replaceAll("\"", "\\\\\"").replaceAll(",", "\\\\,");
                sb.append(valStr + "\t").append(",");
            }
            sb.append("\r\n");
        }
        return new ByteArrayInputStream(sb.toString().getBytes("utf-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> parseCsv(InputStream in) throws IOException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        String line = null;
        List titles = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            boolean isFirst = true;
            while ((line = reader.readLine()) != null) {
                if (isFirst) {
                    titles = Arrays.asList(line.split(",")).stream().map(item -> item.trim()).collect(Collectors.toList());
                    isFirst = false;
                    continue;
                }
                LinkedHashMap<String, String> item2 = new LinkedHashMap<String, String>();
                List<String> itemData = Arrays.asList(line.split(","));
                for (int i = 0; i < titles.size(); ++i) {
                    item2.put(((String)titles.get(i)).trim(), itemData.get(i).trim());
                }
                result.add(item2);
            }
            ArrayList<Map<String, String>> arrayList = result;
            return arrayList;
        }
        finally {
            if (Collections.singletonList(reader).get(0) != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> parseCsv(List<String> titles, InputStream in) throws IOException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        String line = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            while ((line = reader.readLine()) != null) {
                LinkedHashMap<String, String> item = new LinkedHashMap<String, String>();
                List<String> itemData = Arrays.asList(line.split(","));
                for (int i = 0; i < titles.size(); ++i) {
                    item.put(titles.get(i).trim(), itemData.get(i).trim());
                }
                result.add(item);
            }
            ArrayList<Map<String, String>> arrayList = result;
            return arrayList;
        }
        finally {
            if (Collections.singletonList(reader).get(0) != null) {
                reader.close();
            }
        }
    }
}

