/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtils {
    public static ByteArrayInputStream writeXls(Map<String, String> title, List<Map<String, Object>> list) throws IOException {
        HSSFCell cell;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet();
        HSSFRow row = sheet.createRow(0);
        Object[] arrTitle = title.values().toArray();
        for (int i = 0; i < arrTitle.length; ++i) {
            Object item = arrTitle[i];
            cell = row.createCell(i);
            cell.setCellValue(item.toString());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Set<String> titleKeys = title.keySet();
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> info = list.get(i);
            row = sheet.createRow(i + 1);
            int col = 0;
            for (String key : titleKeys) {
                Object valObj = info.get(key);
                String valStr = null;
                valStr = valObj instanceof Date ? (valObj == null ? "" : sdf.format(valObj)) : (valObj == null ? "" : valObj.toString());
                cell = row.createCell(col++);
                cell.setCellValue(valStr);
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        wb.write((OutputStream)os);
        return new ByteArrayInputStream(os.toByteArray());
    }

    public static List<Map<String, String>> parseXls(InputStream in) throws IOException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        HSSFWorkbook workbook = new HSSFWorkbook(in);
        HSSFSheet sheet = workbook.getSheetAt(0);
        if (sheet == null) {
            return result;
        }
        ArrayList<String> titles = null;
        for (int i = 0; i < sheet.getPhysicalNumberOfRows(); ++i) {
            HSSFRow row = sheet.getRow(i);
            if (i == 0) {
                titles = new ArrayList<String>(row.getLastCellNum());
                for (int k = 0; k < row.getLastCellNum(); ++k) {
                    HSSFCell cell = row.getCell(k);
                    cell.setCellType(CellType.STRING);
                    titles.add(cell.getStringCellValue().trim());
                }
                continue;
            }
            LinkedHashMap item = new LinkedHashMap(row.getLastCellNum());
            result.add(item);
            for (int k = 0; k < row.getLastCellNum(); ++k) {
                HSSFCell cell = row.getCell(k);
                cell.setCellType(CellType.STRING);
                item.put(titles.get(k), cell.getStringCellValue().trim());
            }
        }
        return result;
    }

    public static ByteArrayInputStream writeXlsx(Map<String, String> title, List<Map<String, Object>> list) throws IOException {
        XSSFCell cell;
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet();
        XSSFRow row = sheet.createRow(0);
        Object[] arrTitle = title.values().toArray();
        for (int i = 0; i < arrTitle.length; ++i) {
            Object item = arrTitle[i];
            cell = row.createCell(i);
            cell.setCellValue(item.toString());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Set<String> titleKeys = title.keySet();
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> info = list.get(i);
            row = sheet.createRow(i + 1);
            int col = 0;
            for (String key : titleKeys) {
                Object valObj = info.get(key);
                String valStr = null;
                valStr = valObj instanceof Date ? (valObj == null ? "" : sdf.format(valObj)) : (valObj == null ? "" : valObj.toString());
                cell = row.createCell(col++);
                cell.setCellValue(valStr);
            }
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        wb.write((OutputStream)os);
        return new ByteArrayInputStream(os.toByteArray());
    }

    public static List<Map<String, String>> parseXlsx(InputStream in) throws IOException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        XSSFWorkbook workbook = new XSSFWorkbook(in);
        XSSFSheet sheet = workbook.getSheetAt(0);
        if (sheet == null) {
            return result;
        }
        ArrayList<String> titles = null;
        for (int i = 0; i < sheet.getPhysicalNumberOfRows(); ++i) {
            XSSFRow row = sheet.getRow(i);
            if (i == 0) {
                titles = new ArrayList<String>(row.getLastCellNum());
                for (int k = 0; k < row.getLastCellNum(); ++k) {
                    XSSFCell cell = row.getCell(k);
                    cell.setCellType(CellType.STRING);
                    titles.add(cell.getStringCellValue().trim());
                }
                continue;
            }
            LinkedHashMap item = new LinkedHashMap(row.getLastCellNum());
            result.add(item);
            for (int k = 0; k < row.getLastCellNum(); ++k) {
                XSSFCell cell = row.getCell(k);
                cell.setCellType(CellType.STRING);
                item.put(titles.get(k), cell.getStringCellValue().trim());
            }
        }
        return result;
    }
}

