/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.utils;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenerateId
implements Comparable<GenerateId>,
Serializable {
    private static final long serialVersionUID = 3670079982654483072L;
    private static final int LOW_ORDER_THREE_BYTES = 0xFFFFFF;
    private static final int MACHINE_IDENTIFIER;
    private static final short PROCESS_IDENTIFIER;
    private static final AtomicInteger NEXT_COUNTER;
    private static final Logger LOG;
    private final int timestamp;
    private final int machineIdentifier;
    private final short processIdentifier;
    private final int counter;

    public static GenerateId get() {
        return new GenerateId();
    }

    public static boolean isValid(String hexString) {
        if (hexString == null) {
            throw new IllegalArgumentException();
        }
        int len = hexString.length();
        if (len != 24) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static int getGeneratedMachineIdentifier() {
        return MACHINE_IDENTIFIER;
    }

    public static int getGeneratedProcessIdentifier() {
        return PROCESS_IDENTIFIER;
    }

    public static int getCurrentCounter() {
        return NEXT_COUNTER.get();
    }

    public static GenerateId createFromLegacyFormat(int time, int machine, int inc) {
        return new GenerateId(time, machine, inc);
    }

    public GenerateId() {
        this(new Date());
    }

    public GenerateId(Date date) {
        this(GenerateId.dateToTimestampSeconds(date), MACHINE_IDENTIFIER, PROCESS_IDENTIFIER, NEXT_COUNTER.getAndIncrement(), false);
    }

    public GenerateId(Date date, int counter) {
        this(date, MACHINE_IDENTIFIER, PROCESS_IDENTIFIER, counter);
    }

    public GenerateId(Date date, int machineIdentifier, short processIdentifier, int counter) {
        this(GenerateId.dateToTimestampSeconds(date), machineIdentifier, processIdentifier, counter);
    }

    public GenerateId(int timestamp, int machineIdentifier, short processIdentifier, int counter) {
        this(timestamp, machineIdentifier, processIdentifier, counter, true);
    }

    private GenerateId(int timestamp, int machineIdentifier, short processIdentifier, int counter, boolean checkCounter) {
        if ((machineIdentifier & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The machine identifier must be between 0 and 16777215 (it must fit in three bytes).");
        }
        if (checkCounter && (counter & 0xFF000000) != 0) {
            throw new IllegalArgumentException("The counter must be between 0 and 16777215 (it must fit in three bytes).");
        }
        this.timestamp = timestamp;
        this.machineIdentifier = machineIdentifier;
        this.processIdentifier = processIdentifier;
        this.counter = counter & 0xFFFFFF;
    }

    public GenerateId(String hexString) {
        this(GenerateId.parseHexString(hexString));
    }

    public GenerateId(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        if (bytes.length != 12) {
            throw new IllegalArgumentException("need 12 bytes");
        }
        this.timestamp = GenerateId.makeInt(bytes[0], bytes[1], bytes[2], bytes[3]);
        this.machineIdentifier = GenerateId.makeInt((byte)0, bytes[4], bytes[5], bytes[6]);
        this.processIdentifier = (short)GenerateId.makeInt((byte)0, (byte)0, bytes[7], bytes[8]);
        this.counter = GenerateId.makeInt((byte)0, bytes[9], bytes[10], bytes[11]);
    }

    GenerateId(int timestamp, int machineAndProcessIdentifier, int counter) {
        this(GenerateId.legacyToBytes(timestamp, machineAndProcessIdentifier, counter));
    }

    private static byte[] legacyToBytes(int timestamp, int machineAndProcessIdentifier, int counter) {
        byte[] bytes = new byte[]{GenerateId.int3(timestamp), GenerateId.int2(timestamp), GenerateId.int1(timestamp), GenerateId.int0(timestamp), GenerateId.int3(machineAndProcessIdentifier), GenerateId.int2(machineAndProcessIdentifier), GenerateId.int1(machineAndProcessIdentifier), GenerateId.int0(machineAndProcessIdentifier), GenerateId.int3(counter), GenerateId.int2(counter), GenerateId.int1(counter), GenerateId.int0(counter)};
        return bytes;
    }

    public byte[] toByteArray() {
        byte[] bytes = new byte[]{GenerateId.int3(this.timestamp), GenerateId.int2(this.timestamp), GenerateId.int1(this.timestamp), GenerateId.int0(this.timestamp), GenerateId.int2(this.machineIdentifier), GenerateId.int1(this.machineIdentifier), GenerateId.int0(this.machineIdentifier), GenerateId.short1(this.processIdentifier), GenerateId.short0(this.processIdentifier), GenerateId.int2(this.counter), GenerateId.int1(this.counter), GenerateId.int0(this.counter)};
        return bytes;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getMachineIdentifier() {
        return this.machineIdentifier;
    }

    public short getProcessIdentifier() {
        return this.processIdentifier;
    }

    public int getCounter() {
        return this.counter;
    }

    public Date getDate() {
        return new Date((long)this.timestamp * 1000L);
    }

    public String toHexString() {
        StringBuilder buf = new StringBuilder(24);
        for (byte b : this.toByteArray()) {
            buf.append(String.format("%02x", b & 0xFF));
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerateId Objectx = (GenerateId)o;
        if (this.counter != Objectx.counter) {
            return false;
        }
        if (this.machineIdentifier != Objectx.machineIdentifier) {
            return false;
        }
        if (this.processIdentifier != Objectx.processIdentifier) {
            return false;
        }
        return this.timestamp == Objectx.timestamp;
    }

    public int hashCode() {
        int result = this.timestamp;
        result = 31 * result + this.machineIdentifier;
        result = 31 * result + this.processIdentifier;
        result = 31 * result + this.counter;
        return result;
    }

    @Override
    public int compareTo(GenerateId other) {
        if (other == null) {
            throw new NullPointerException();
        }
        int x = this.timestamp - other.timestamp;
        if (x != 0) {
            return x;
        }
        x = this.machineIdentifier - other.machineIdentifier;
        if (x != 0) {
            return x;
        }
        x = this.processIdentifier - other.processIdentifier;
        if (x != 0) {
            return x;
        }
        return this.counter - other.counter;
    }

    public String toString() {
        return this.toHexString();
    }

    private static int createMachineIdentifier() {
        int machinePiece;
        try {
            StringBuilder sb = new StringBuilder();
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface ni = e.nextElement();
                sb.append(ni.toString());
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                ByteBuffer bb = ByteBuffer.wrap(mac);
                try {
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                    sb.append(bb.getChar());
                }
                catch (BufferUnderflowException bufferUnderflowException) {}
            }
            machinePiece = sb.toString().hashCode();
        }
        catch (Throwable t) {
            machinePiece = new SecureRandom().nextInt();
            LOG.warn("Failed to get machine identifier from network interface, using random number instead,error:{}", t);
        }
        return machinePiece &= 0xFFFFFF;
    }

    private static short createProcessIdentifier() {
        short processId;
        try {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            processId = processName.contains("@") ? (short)Integer.parseInt(processName.substring(0, processName.indexOf(64))) : (short)ManagementFactory.getRuntimeMXBean().getName().hashCode();
        }
        catch (Throwable t) {
            processId = (short)new SecureRandom().nextInt();
            LOG.warn("Failed to get process identifier from JMX, using random number instead,error:{}", t);
        }
        return processId;
    }

    private static byte[] parseHexString(String s) {
        if (!GenerateId.isValid(s)) {
            throw new IllegalArgumentException("invalid hexadecimal representation of an Objectx: [" + s + "]");
        }
        byte[] b = new byte[12];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16);
        }
        return b;
    }

    private static int dateToTimestampSeconds(Date time) {
        return (int)(time.getTime() / 1000L);
    }

    private static int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    private static byte int3(int x) {
        return (byte)(x >> 24);
    }

    private static byte int2(int x) {
        return (byte)(x >> 16);
    }

    private static byte int1(int x) {
        return (byte)(x >> 8);
    }

    private static byte int0(int x) {
        return (byte)x;
    }

    private static byte short1(short x) {
        return (byte)(x >> 8);
    }

    private static byte short0(short x) {
        return (byte)x;
    }

    static {
        NEXT_COUNTER = new AtomicInteger(new SecureRandom().nextInt());
        LOG = LoggerFactory.getLogger(GenerateId.class);
        try {
            MACHINE_IDENTIFIER = GenerateId.createMachineIdentifier();
            PROCESS_IDENTIFIER = GenerateId.createProcessIdentifier();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

