/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.utils;

import com.github.alenfive.rocketapi.entity.vo.ScriptContext;
import com.github.alenfive.rocketapi.service.ScriptParseService;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFormatUtils {
    private static final Logger log = LoggerFactory.getLogger(LogFormatUtils.class);

    public static String sqlParam(StringBuilder script, ScriptParseService parseService, ScriptContext scriptContext) {
        try {
            StringBuilder res = new StringBuilder();
            for (Map<String, Object> item : scriptContext.getParams()) {
                String itemStr = script.toString();
                for (String key : item.keySet()) {
                    String replacement = Matcher.quoteReplacement(parseService.buildFormatValue(item.get(key), scriptContext.getDataSourceDialect()));
                    itemStr = itemStr.replaceAll(":" + key, replacement);
                }
                res.append("\r\n").append(itemStr);
            }
            return res.toString();
        }
        catch (Exception e) {
            StringBuilder res = new StringBuilder("sql param format error:").append((CharSequence)script);
            return res.toString();
        }
    }

    private static String buildValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "'" + value.toString() + "'";
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
        }
        return value.toString();
    }
}

