/*
 * Decompiled with CFR 0.152.
 */
package com.github.alenfive.rocketapi.utils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PackageUtil {
    public static List<Class> loadClassByLoader(ClassLoader load) throws Exception {
        Enumeration<URL> urls = load.getResources("");
        ArrayList<Class> classes = new ArrayList<Class>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (!url.getProtocol().equals("file")) continue;
            PackageUtil.loadClassByPath(null, url.getPath(), classes, load);
        }
        return classes;
    }

    public static void loadClassByPath(String root, String path, List<Class> list, ClassLoader load) {
        File f = new File(path);
        if (root == null) {
            root = f.getPath();
        }
        if (f.isFile() && f.getName().matches("^.*\\.class$")) {
            try {
                String classPath = f.getPath();
                String className = classPath.substring(root.length() + 1, classPath.length() - 6).replace('/', '.').replace('\\', '.');
                list.add(load.loadClass(className));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            File[] fs = f.listFiles();
            if (fs == null) {
                return;
            }
            for (File file : fs) {
                PackageUtil.loadClassByPath(root, file.getPath(), list, load);
            }
        }
    }

    public static List<String> scan() throws URISyntaxException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        HashSet<String> classes = new HashSet<String>();
        do {
            if (!(loader instanceof URLClassLoader)) continue;
            classes.addAll(PackageUtil.scan(((URLClassLoader)loader).getURLs()));
        } while ((loader = loader.getParent()) != null);
        return new ArrayList<String>(classes);
    }

    private static Set<String> scan(URL[] urls) throws URISyntaxException {
        HashSet<String> classes = new HashSet<String>();
        if (urls != null) {
            for (URL url : urls) {
                String protocol = url.getProtocol();
                if ("file".equalsIgnoreCase(protocol)) {
                    String path = url.getPath();
                    if (path.toLowerCase().endsWith(".jar")) {
                        classes.addAll(PackageUtil.scanJarFile(url));
                        continue;
                    }
                    classes.addAll(PackageUtil.scanDirectory(new File(url.toURI()), null));
                    continue;
                }
                if (!"jar".equalsIgnoreCase(protocol)) continue;
                classes.addAll(PackageUtil.scanJarFile(url));
            }
        }
        return classes;
    }

    private static List<String> scanDirectory(File dir, String packageName) {
        File[] files = dir.listFiles();
        ArrayList<String> classes = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (file.isDirectory()) {
                    classes.addAll(PackageUtil.scanDirectory(file, packageName == null ? name : packageName + "." + name));
                    continue;
                }
                if (!name.endsWith(".class") || name.contains("$")) continue;
                classes.add(PackageUtil.filterFullName(packageName + "." + name.substring(0, name.length() - 6)));
            }
        }
        return classes;
    }

    private static String filterFullName(String fullName) {
        if (fullName.startsWith("BOOT-INF.classes.")) {
            fullName = fullName.substring(17);
        }
        return fullName;
    }

    private static List<String> scanJarFile(URL url) {
        ArrayList<String> classes = new ArrayList<String>();
        try (ZipInputStream zis = new ZipInputStream(url.openStream());){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                String className;
                if (entry.getName().contains("META-INF") || !(className = entry.getName()).endsWith(".class") || className.contains("$")) continue;
                classes.add(PackageUtil.filterFullName(className.substring(0, className.length() - 6).replace("/", ".")));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classes;
    }
}

