/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database;

import cn.org.atool.generator.util.GeneratorHelper;

public enum DbTypeOfGenerator {
    MYSQL("mysql", "MySql\u6570\u636e\u5e93"),
    MARIADB("mariadb", "MariaDB\u6570\u636e\u5e93"),
    ORACLE("oracle", "Oracle\u6570\u636e\u5e93"),
    DB2("db2", "DB2\u6570\u636e\u5e93"),
    H2("h2", "H2\u6570\u636e\u5e93"),
    SQLITE("sqlite", "SQLite\u6570\u636e\u5e93"),
    POSTGRE_SQL("postgresql", "Postgre\u6570\u636e\u5e93"),
    SQL_SERVER("sqlserver", "SQLServer\u6570\u636e\u5e93");

    private final String db;
    private final String desc;

    private DbTypeOfGenerator(String db, String desc) {
        this.db = db;
        this.desc = desc;
    }

    public static DbTypeOfGenerator getDbType(String driverName, String url) {
        DbTypeOfGenerator dbType = DbTypeOfGenerator.isDbType(driverName);
        if (dbType == null) {
            dbType = DbTypeOfGenerator.isDbType(url);
        }
        return dbType == null ? MYSQL : dbType;
    }

    private static DbTypeOfGenerator isDbType(String info) {
        DbTypeOfGenerator[] dbTypes;
        if (GeneratorHelper.isBlank(info)) {
            return null;
        }
        String temp = info.toLowerCase();
        for (DbTypeOfGenerator type : dbTypes = DbTypeOfGenerator.values()) {
            if (!temp.contains(type.db)) continue;
            return type;
        }
        return null;
    }

    public String getDb() {
        return this.db;
    }

    public String getDesc() {
        return this.desc;
    }
}

