/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.config.impl;

import cn.org.atool.generator.database.DbTypeOfGenerator;
import cn.org.atool.generator.database.IGlobalConfigSet;
import cn.org.atool.generator.database.model.DataSourceSetter;
import cn.org.atool.generator.database.model.Naming;
import cn.org.atool.generator.util.GeneratorHelper;
import java.sql.Connection;
import java.util.Objects;
import javax.sql.DataSource;

public class GlobalConfig
implements IGlobalConfigSet {
    private Naming tableNaming = Naming.underline_to_camel;
    private Naming columnNaming;
    private boolean removeIsPrefix = false;
    private String schemaName;
    private String basePackage;
    private String daoPackage;
    private String packageDir;
    private String daoDir;
    private String outputDir = System.getProperty("user.dir") + "/target/generate/base";
    private String testOutputDir = System.getProperty("user.dir") + "/target/generate/test";
    private String daoOutputDir = System.getProperty("user.dir") + "/target/generate/dao";
    private String author = "generate code";
    private boolean alphabetOrder = true;
    private DataSourceSetter dataSourceSetter;

    public Naming getColumnNaming() {
        return this.columnNaming == null ? this.tableNaming : this.columnNaming;
    }

    @Override
    public IGlobalConfigSet setBasePackage(String basePackage) {
        this.basePackage = basePackage;
        this.packageDir = '/' + basePackage.replace('.', '/') + '/';
        if (GeneratorHelper.isBlank(this.daoPackage)) {
            this.setDaoPackage(basePackage);
        }
        return this;
    }

    @Override
    public IGlobalConfigSet setDaoPackage(String daoPackage) {
        this.daoPackage = daoPackage;
        this.daoDir = '/' + daoPackage.replace('.', '/') + '/';
        return this;
    }

    public String getBasePackage() {
        if (GeneratorHelper.isBlank(this.basePackage)) {
            throw new RuntimeException("The base package should be set.");
        }
        return this.basePackage;
    }

    @Override
    public IGlobalConfigSet setOutputDir(String outputDir) {
        return this.setOutputDir(outputDir, outputDir, outputDir);
    }

    @Override
    public IGlobalConfigSet setOutputDir(String outputDir, String testOutputDir, String daoOutputDir) {
        this.outputDir = outputDir;
        this.testOutputDir = testOutputDir;
        this.daoOutputDir = daoOutputDir;
        return this;
    }

    @Override
    public IGlobalConfigSet setDataSource(DbTypeOfGenerator dbType, DataSource dataSource) {
        this.dataSourceSetter = new DataSourceSetter(dbType, dataSource);
        return this;
    }

    @Override
    public IGlobalConfigSet setDataSource(String url, String username, String password) {
        return this.setDataSource(DbTypeOfGenerator.MYSQL, "com.mysql.jdbc.Driver", url, username, password);
    }

    @Override
    public IGlobalConfigSet setDataSource(DbTypeOfGenerator dbType, String driver, String url, String username, String password) {
        this.dataSourceSetter = new DataSourceSetter(dbType, driver, url, username, password);
        return this;
    }

    @Override
    public Connection getConnection() {
        return this.dataSourceSetter.getConn();
    }

    public DbTypeOfGenerator getDbType() {
        return this.dataSourceSetter.getDbType();
    }

    public boolean needRemoveIsPrefix(String fieldName, Class fieldType) {
        if (!this.isRemoveIsPrefix()) {
            return false;
        }
        if (!Objects.equals(Boolean.TYPE, fieldType)) {
            return false;
        }
        return fieldName.startsWith("is");
    }

    public Naming getTableNaming() {
        return this.tableNaming;
    }

    public boolean isRemoveIsPrefix() {
        return this.removeIsPrefix;
    }

    public String getDaoPackage() {
        return this.daoPackage;
    }

    public String getPackageDir() {
        return this.packageDir;
    }

    public String getDaoDir() {
        return this.daoDir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public String getTestOutputDir() {
        return this.testOutputDir;
    }

    public String getDaoOutputDir() {
        return this.daoOutputDir;
    }

    public String getAuthor() {
        return this.author;
    }

    public boolean isAlphabetOrder() {
        return this.alphabetOrder;
    }

    public DataSourceSetter getDataSourceSetter() {
        return this.dataSourceSetter;
    }

    public GlobalConfig setTableNaming(Naming tableNaming) {
        this.tableNaming = tableNaming;
        return this;
    }

    public GlobalConfig setColumnNaming(Naming columnNaming) {
        this.columnNaming = columnNaming;
        return this;
    }

    public GlobalConfig setRemoveIsPrefix(boolean removeIsPrefix) {
        this.removeIsPrefix = removeIsPrefix;
        return this;
    }

    @Override
    public GlobalConfig setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public GlobalConfig setAuthor(String author) {
        this.author = author;
        return this;
    }

    public GlobalConfig setDataSourceSetter(DataSourceSetter dataSourceSetter) {
        this.dataSourceSetter = dataSourceSetter;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalConfig)) {
            return false;
        }
        GlobalConfig other = (GlobalConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRemoveIsPrefix() != other.isRemoveIsPrefix()) {
            return false;
        }
        if (this.isAlphabetOrder() != other.isAlphabetOrder()) {
            return false;
        }
        Naming this$tableNaming = this.getTableNaming();
        Naming other$tableNaming = other.getTableNaming();
        if (this$tableNaming == null ? other$tableNaming != null : !((Object)((Object)this$tableNaming)).equals((Object)other$tableNaming)) {
            return false;
        }
        Naming this$columnNaming = this.getColumnNaming();
        Naming other$columnNaming = other.getColumnNaming();
        if (this$columnNaming == null ? other$columnNaming != null : !((Object)((Object)this$columnNaming)).equals((Object)other$columnNaming)) {
            return false;
        }
        String this$schemaName = this.getSchemaName();
        String other$schemaName = other.getSchemaName();
        if (this$schemaName == null ? other$schemaName != null : !this$schemaName.equals(other$schemaName)) {
            return false;
        }
        String this$basePackage = this.getBasePackage();
        String other$basePackage = other.getBasePackage();
        if (this$basePackage == null ? other$basePackage != null : !this$basePackage.equals(other$basePackage)) {
            return false;
        }
        String this$daoPackage = this.getDaoPackage();
        String other$daoPackage = other.getDaoPackage();
        if (this$daoPackage == null ? other$daoPackage != null : !this$daoPackage.equals(other$daoPackage)) {
            return false;
        }
        String this$packageDir = this.getPackageDir();
        String other$packageDir = other.getPackageDir();
        if (this$packageDir == null ? other$packageDir != null : !this$packageDir.equals(other$packageDir)) {
            return false;
        }
        String this$daoDir = this.getDaoDir();
        String other$daoDir = other.getDaoDir();
        if (this$daoDir == null ? other$daoDir != null : !this$daoDir.equals(other$daoDir)) {
            return false;
        }
        String this$outputDir = this.getOutputDir();
        String other$outputDir = other.getOutputDir();
        if (this$outputDir == null ? other$outputDir != null : !this$outputDir.equals(other$outputDir)) {
            return false;
        }
        String this$testOutputDir = this.getTestOutputDir();
        String other$testOutputDir = other.getTestOutputDir();
        if (this$testOutputDir == null ? other$testOutputDir != null : !this$testOutputDir.equals(other$testOutputDir)) {
            return false;
        }
        String this$daoOutputDir = this.getDaoOutputDir();
        String other$daoOutputDir = other.getDaoOutputDir();
        if (this$daoOutputDir == null ? other$daoOutputDir != null : !this$daoOutputDir.equals(other$daoOutputDir)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        DataSourceSetter this$dataSourceSetter = this.getDataSourceSetter();
        DataSourceSetter other$dataSourceSetter = other.getDataSourceSetter();
        return !(this$dataSourceSetter == null ? other$dataSourceSetter != null : !this$dataSourceSetter.equals(other$dataSourceSetter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRemoveIsPrefix() ? 79 : 97);
        result = result * 59 + (this.isAlphabetOrder() ? 79 : 97);
        Naming $tableNaming = this.getTableNaming();
        result = result * 59 + ($tableNaming == null ? 43 : ((Object)((Object)$tableNaming)).hashCode());
        Naming $columnNaming = this.getColumnNaming();
        result = result * 59 + ($columnNaming == null ? 43 : ((Object)((Object)$columnNaming)).hashCode());
        String $schemaName = this.getSchemaName();
        result = result * 59 + ($schemaName == null ? 43 : $schemaName.hashCode());
        String $basePackage = this.getBasePackage();
        result = result * 59 + ($basePackage == null ? 43 : $basePackage.hashCode());
        String $daoPackage = this.getDaoPackage();
        result = result * 59 + ($daoPackage == null ? 43 : $daoPackage.hashCode());
        String $packageDir = this.getPackageDir();
        result = result * 59 + ($packageDir == null ? 43 : $packageDir.hashCode());
        String $daoDir = this.getDaoDir();
        result = result * 59 + ($daoDir == null ? 43 : $daoDir.hashCode());
        String $outputDir = this.getOutputDir();
        result = result * 59 + ($outputDir == null ? 43 : $outputDir.hashCode());
        String $testOutputDir = this.getTestOutputDir();
        result = result * 59 + ($testOutputDir == null ? 43 : $testOutputDir.hashCode());
        String $daoOutputDir = this.getDaoOutputDir();
        result = result * 59 + ($daoOutputDir == null ? 43 : $daoOutputDir.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        DataSourceSetter $dataSourceSetter = this.getDataSourceSetter();
        result = result * 59 + ($dataSourceSetter == null ? 43 : $dataSourceSetter.hashCode());
        return result;
    }

    public String toString() {
        return "GlobalConfig(tableNaming=" + (Object)((Object)this.getTableNaming()) + ", columnNaming=" + (Object)((Object)this.getColumnNaming()) + ", removeIsPrefix=" + this.isRemoveIsPrefix() + ", schemaName=" + this.getSchemaName() + ", basePackage=" + this.getBasePackage() + ", daoPackage=" + this.getDaoPackage() + ", packageDir=" + this.getPackageDir() + ", daoDir=" + this.getDaoDir() + ", outputDir=" + this.getOutputDir() + ", testOutputDir=" + this.getTestOutputDir() + ", daoOutputDir=" + this.getDaoOutputDir() + ", author=" + this.getAuthor() + ", alphabetOrder=" + this.isAlphabetOrder() + ", dataSourceSetter=" + this.getDataSourceSetter() + ")";
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public GlobalConfig setAlphabetOrder(boolean alphabetOrder) {
        this.alphabetOrder = alphabetOrder;
        return this;
    }
}

