/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.config.impl;

import cn.org.atool.generator.database.ITableConfigSet;
import cn.org.atool.generator.database.config.impl.GlobalConfig;
import cn.org.atool.generator.database.config.impl.RelationConfig;
import cn.org.atool.generator.database.model.TableSetter;
import cn.org.atool.generator.javafile.template.EntityFile;
import cn.org.atool.generator.util.SchemaKits;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import schemacrawler.schema.Table;

public class TableConfigSet
implements ITableConfigSet {
    private final GlobalConfig globalConfig;
    private Map<String, TableSetter> tables = new HashMap<String, TableSetter>();

    public TableConfigSet(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    @Override
    public ITableConfigSet table(String tableName) {
        return this.table(tableName, table -> {});
    }

    @Override
    public ITableConfigSet table(String tableName, Consumer<TableSetter> consumer) {
        TableSetter table = new TableSetter(tableName, this.globalConfig, this);
        consumer.accept(table);
        this.tables.put(tableName, table);
        return this;
    }

    @Override
    public void foreach(Consumer<TableSetter> consumer) {
        this.tables.values().forEach(consumer);
    }

    @Override
    public TableSetter getTableSetter(String tableName) {
        return this.tables.get(tableName);
    }

    public void initTables() {
        HashSet<String> existed = new HashSet<String>();
        Collection<Table> tables = SchemaKits.getTables(this.globalConfig.getConnection(), this.globalConfig.getSchemaName());
        for (Table table : tables) {
            String tableName = table.getName();
            TableSetter tableSetter = this.getTables().get(tableName);
            if (tableSetter == null) continue;
            existed.add(tableName);
            tableSetter.setComment(table.getRemarks());
            tableSetter.initTable(table.getColumns());
        }
        Set<String> all = this.getTables().keySet();
        for (String table : all) {
            if (existed.contains(table)) continue;
            System.err.println("Table '" + table + "' not exist in database !!!");
            this.getTables().remove(table);
        }
    }

    public void initRelations() {
        for (Map.Entry<String, TableSetter> entry : this.getTables().entrySet()) {
            TableSetter source = entry.getValue();
            if (source.getRelations().isEmpty()) continue;
            for (RelationConfig relation : source.getRelations()) {
                TableSetter target = this.getTables().get(relation.getTargetTable());
                relation.setSourcePackage(EntityFile.entityPackage(source));
                relation.setSourceEntity(EntityFile.entityClass(source));
                relation.setTargetNoSuffix(target.getEntityPrefix());
                relation.setTargetPackage(EntityFile.entityPackage(target));
                relation.setTargetEntity(EntityFile.entityClass(target));
                relation.properties(source, target);
            }
        }
    }

    public void add(TableConfigSet tc) {
        this.tables.putAll(tc.getTables());
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public TableConfigSet setTables(Map<String, TableSetter> tables) {
        this.tables = tables;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableConfigSet)) {
            return false;
        }
        TableConfigSet other = (TableConfigSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GlobalConfig this$globalConfig = this.getGlobalConfig();
        GlobalConfig other$globalConfig = other.getGlobalConfig();
        if (this$globalConfig == null ? other$globalConfig != null : !((Object)this$globalConfig).equals(other$globalConfig)) {
            return false;
        }
        Map<String, TableSetter> this$tables = this.getTables();
        Map<String, TableSetter> other$tables = other.getTables();
        return !(this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableConfigSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GlobalConfig $globalConfig = this.getGlobalConfig();
        result = result * 59 + ($globalConfig == null ? 43 : ((Object)$globalConfig).hashCode());
        Map<String, TableSetter> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
        return result;
    }

    public String toString() {
        return "TableConfigSet(globalConfig=" + this.getGlobalConfig() + ", tables=" + this.getTables() + ")";
    }

    public Map<String, TableSetter> getTables() {
        return this.tables;
    }
}

