/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.model;

import cn.org.atool.generator.database.DbTypeOfGenerator;
import cn.org.atool.generator.util.GeneratorHelper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceSetter {
    private DbTypeOfGenerator dbType;
    private String driverName;
    private String url;
    private String username;
    private String password;
    private DataSource dataSource;
    private Class driverClass;

    public DataSourceSetter(DbTypeOfGenerator dbType, DataSource dataSource) {
        if (GeneratorHelper.isBlank(this.url) && dataSource == null) {
            throw new RuntimeException("Database connection url cannot cannot be null");
        }
        this.dbType = dbType;
        this.dataSource = dataSource;
    }

    public DataSourceSetter(DbTypeOfGenerator dbType, String driverName, String url, String username, String password) {
        if (url == null) {
            throw new RuntimeException("Database connection url cannot cannot be null");
        }
        this.driverName = driverName;
        this.url = url;
        this.username = username;
        this.password = password;
        this.dbType = dbType;
        if (null == this.dbType) {
            this.dbType = DbTypeOfGenerator.getDbType(this.driverName, this.url);
        }
    }

    public Connection getConn() {
        try {
            if (this.dataSource != null) {
                return this.dataSource.getConnection();
            }
            if (!GeneratorHelper.isBlank(this.url)) {
                this.initDriverIfNeed();
                return DriverManager.getConnection(this.url, this.username, this.password);
            }
            throw new RuntimeException("dataSource needs to be specified.");
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new RuntimeException("Get Connection error:" + e.getMessage(), e);
        }
    }

    private void initDriverIfNeed() throws ClassNotFoundException {
        if (this.driverClass == null) {
            this.driverClass = Class.forName(this.driverName);
        }
    }

    public DataSourceSetter setDbType(DbTypeOfGenerator dbType) {
        this.dbType = dbType;
        return this;
    }

    public DataSourceSetter setDriverName(String driverName) {
        this.driverName = driverName;
        return this;
    }

    public DataSourceSetter setUrl(String url) {
        this.url = url;
        return this;
    }

    public DataSourceSetter setUsername(String username) {
        this.username = username;
        return this;
    }

    public DataSourceSetter setPassword(String password) {
        this.password = password;
        return this;
    }

    public DataSourceSetter setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public DataSourceSetter setDriverClass(Class driverClass) {
        this.driverClass = driverClass;
        return this;
    }

    public DbTypeOfGenerator getDbType() {
        return this.dbType;
    }
}

