/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.model;

import cn.org.atool.generator.database.config.impl.GlobalConfig;
import cn.org.atool.generator.database.model.CustomizedColumn;
import cn.org.atool.generator.database.model.FieldType;
import cn.org.atool.generator.database.model.Naming;
import cn.org.atool.generator.util.GeneratorHelper;
import java.util.Date;
import java.util.Objects;
import org.apache.ibatis.type.TypeHandler;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;

public class TableField
implements Comparable<TableField> {
    private final GlobalConfig globalConfig;
    private FieldType category = FieldType.Common;
    private final String columnName;
    private String name;
    private Class javaType;
    private Class<? extends TypeHandler> typeHandler;
    private String insert;
    private String update;
    private Boolean isLarge;
    private String capitalName;
    private String jdbcType;
    private boolean notNull = false;
    private String defaults = null;
    private String comment;

    public TableField(GlobalConfig globalConfig, String columnName, CustomizedColumn defined) {
        this.globalConfig = globalConfig;
        this.columnName = columnName;
        if (defined != null) {
            defined.initField(this);
        }
    }

    public void initNamingAndType(Column column) {
        this.jdbcType = ((ColumnDataType)column.getType()).getName() + column.getWidth();
        this.initFieldNameIfNeed();
        String capitalName = Naming.capitalFirst(this.removeIsIfNeed(this.name, this.globalConfig));
        this.initJavaTypeIfNeed(column);
        this.notNull = !column.isNullable();
        this.defaults = column.getDefaultValue();
        if (!GeneratorHelper.isBlank(this.defaults) && this.isStringType()) {
            this.defaults = "'" + this.defaults + "'";
        }
        this.comment = column.getRemarks();
    }

    private boolean isStringType() {
        return Objects.equals(String.class, this.javaType);
    }

    private void initJavaTypeIfNeed(Column column) {
        if (this.javaType != null) {
            return;
        }
        this.javaType = column.getColumnDataType().getJavaSqlType().getDefaultMappedClass();
        if (Date.class.isAssignableFrom(this.javaType)) {
            this.javaType = Date.class;
        }
    }

    private void initFieldNameIfNeed() {
        if (!GeneratorHelper.isBlank(this.name)) {
            return;
        }
        Naming naming = this.globalConfig.getColumnNaming();
        this.name = naming == Naming.underline_to_camel ? Naming.underlineToCamel(this.columnName) : this.columnName;
    }

    private String removeIsIfNeed(String input, GlobalConfig globalConfig) {
        if (globalConfig.needRemoveIsPrefix(input, this.getJavaType())) {
            return input.substring(2);
        }
        return input;
    }

    public String getType() {
        return this.javaType.getSimpleName();
    }

    public boolean isPrimary() {
        return this.category == FieldType.PrimaryKey || this.category == FieldType.PrimaryId;
    }

    public boolean isPrimaryId() {
        return this.category == FieldType.PrimaryId;
    }

    public boolean isGmt() {
        return this.category == FieldType.GmtCreate || this.category == FieldType.GmtModified;
    }

    public String getColumnType() {
        return this.jdbcType;
    }

    public boolean isDeleted() {
        return this.category == FieldType.IsDeleted;
    }

    @Override
    public int compareTo(TableField field) {
        if (field == null) {
            return 1;
        }
        int order = this.category.compareTo(field.category);
        if (order == 0) {
            order = this.name.compareTo(field.name);
        }
        return order;
    }

    public FieldType getCategory() {
        return this.category;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getName() {
        return this.name;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public Class<? extends TypeHandler> getTypeHandler() {
        return this.typeHandler;
    }

    public String getInsert() {
        return this.insert;
    }

    public String getUpdate() {
        return this.update;
    }

    public Boolean getIsLarge() {
        return this.isLarge;
    }

    public String getCapitalName() {
        return this.capitalName;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public String getDefaults() {
        return this.defaults;
    }

    public String getComment() {
        return this.comment;
    }

    public TableField setCategory(FieldType category) {
        this.category = category;
        return this;
    }

    public TableField setName(String name) {
        this.name = name;
        return this;
    }

    public TableField setJavaType(Class javaType) {
        this.javaType = javaType;
        return this;
    }

    public TableField setTypeHandler(Class<? extends TypeHandler> typeHandler) {
        this.typeHandler = typeHandler;
        return this;
    }

    public TableField setInsert(String insert) {
        this.insert = insert;
        return this;
    }

    public TableField setUpdate(String update) {
        this.update = update;
        return this;
    }

    public TableField setIsLarge(Boolean isLarge) {
        this.isLarge = isLarge;
        return this;
    }
}

