/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.javafile.template;

import cn.org.atool.generator.database.DbTypeOfGenerator;
import cn.org.atool.generator.database.config.impl.RelationConfig;
import cn.org.atool.generator.database.model.TableField;
import cn.org.atool.generator.database.model.TableSetter;
import cn.org.atool.generator.javafile.template.AbstractTemplateFile;
import cn.org.atool.generator.util.ClassNames;
import cn.org.atool.generator.util.GeneratorHelper;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class EntityFile
extends AbstractTemplateFile {
    private static final Set<String> Allow_Entity_Bounds = new HashSet<String>();

    public EntityFile(TableSetter table) {
        super(table);
        this.packageName = EntityFile.entityPackage(table);
        this.klassName = EntityFile.entityClass(table);
    }

    public static TypeName entityName(TableSetter table) {
        return ClassName.get((String)EntityFile.entityPackage(table), (String)EntityFile.entityClass(table), (String[])new String[0]);
    }

    public static String entityPackage(TableSetter table) {
        return table.getBasePackage() + ".entity";
    }

    public static String entityClass(TableSetter table) {
        String entityPrefix = table.getEntityPrefix();
        if (entityPrefix.endsWith(table.getEntitySuffix())) {
            return entityPrefix;
        }
        return entityPrefix + table.getEntitySuffix();
    }

    @Override
    protected void build(TypeSpec.Builder spec) {
        spec.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build()).addAnnotation(ClassNames.Lombok_Data).addAnnotation(AnnotationSpec.builder((ClassName)ClassNames.Lombok_Accessors).addMember("chain", "true", new Object[0]).build()).addAnnotation(AnnotationSpec.builder((ClassName)ClassNames.Lombok_EqualsAndHashCode).addMember("callSuper", "false", new Object[0]).build()).addAnnotation(this.fluentMybatisAnnotation()).addJavadoc("$T: \u6570\u636e\u6620\u5c04\u5b9e\u4f53\u5b9a\u4e49\n\n", new Object[]{super.className()}).addJavadoc("$L", new Object[]{"@author Powered By Fluent Mybatis"});
        spec.superclass((TypeName)ClassNames.FM_RichEntity);
        this.addSuperInterface(spec, this.table.getEntityInterfaces());
        spec.addField(FieldSpec.builder(Long.TYPE, (String)"serialVersionUID", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PRIVATE}).initializer("1L", new Object[0]).build());
        TableField primary = null;
        for (TableField field : this.table.getFields()) {
            FieldSpec.Builder fb = FieldSpec.builder((Type)field.getJavaType(), (String)field.getName(), (Modifier[])new Modifier[]{Modifier.PRIVATE});
            fb.addJavadoc("$L", new Object[]{field.getComment()});
            if (field.isPrimary() && !"user".equals(this.table.getSeqName())) {
                primary = field;
                fb.addAnnotation(this.getTableIdAnnotation(field));
            } else {
                fb.addAnnotation(this.getTableFieldAnnotation(field));
            }
            if (Objects.equals(field.getColumnName(), this.table.getLogicDeleted())) {
                fb.addAnnotation(ClassNames.FM_LogicDelete);
            }
            if (Objects.equals(field.getColumnName(), this.table.getVersionField())) {
                fb.addAnnotation(ClassNames.FM_Version);
            }
            spec.addField(fb.build());
        }
        if (primary != null) {
            spec.addMethod(this.m_findPk(primary));
        }
        spec.addMethod(this.m_entityClass());
        spec.addMethod(this.m_changeTableBelongTo(ClassNames.FM_TableSupplier, "supplier"));
        spec.addMethod(this.m_changeTableBelongTo(ClassNames.CN_String, "table"));
        for (RelationConfig relation : this.table.getRelations()) {
            spec.addMethod(this.m_relation(relation));
        }
    }

    private MethodSpec m_changeTableBelongTo(ClassName pType, String pName) {
        return MethodSpec.methodBuilder((String)"changeTableBelongTo").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).addParameter((TypeName)pType, pName, new Modifier[0]).returns((TypeName)this.className()).addStatement("return super.changeTableBelongTo($L)", new Object[]{pName}).build();
    }

    private MethodSpec m_entityClass() {
        return MethodSpec.methodBuilder((String)"entityClass").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(Override.class).returns(this.parameterizedType(ClassNames.CN_Class, new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ClassNames.FM_IEntity)})).addStatement("return $L.class", new Object[]{EntityFile.entityClass(this.table)}).build();
    }

    private MethodSpec m_relation(RelationConfig relation) {
        String methodName = relation.methodName();
        return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(relation.refMethodAnnotation()).returns(relation.returnType()).addJavadoc("$L", new Object[]{"\u5b9e\u73b0\u5b9a\u4e49\u5728{@link cn.org.atool.fluent.mybatis.base.IRefs}\u5b50\u7c7bRefs\u4e0a"}).addStatement("return super.invoke($S, $L)", new Object[]{methodName, relation.isCached()}).build();
    }

    private AnnotationSpec getTableFieldAnnotation(TableField field) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassNames.FM_TableField).addMember("value", "$S", new Object[]{field.getColumnName()});
        if (!GeneratorHelper.isBlank(field.getInsert())) {
            builder.addMember("insert", "$S", new Object[]{field.getInsert()});
        }
        if (!GeneratorHelper.isBlank(field.getUpdate())) {
            builder.addMember("update", "$S", new Object[]{field.getUpdate()});
        }
        if (field.getIsLarge() != null && !field.getIsLarge().booleanValue()) {
            builder.addMember("notLarge", "$L", new Object[]{Boolean.FALSE.toString()});
        }
        if (field.getTypeHandler() != null) {
            builder.addMember("typeHandler", "$T.class", new Object[]{field.getTypeHandler()});
        }
        return builder.build();
    }

    private AnnotationSpec getTableIdAnnotation(TableField field) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassNames.FM_TableId).addMember("value", "$S", new Object[]{field.getColumnName()});
        String seqName = this.table.getSeqName();
        if (!this.isAuto(seqName, field.isPrimaryId())) {
            builder.addMember("auto", "$L", new Object[]{Boolean.FALSE.toString()});
        }
        if (!GeneratorHelper.isBlank(seqName) && !"auto".equals(seqName)) {
            builder.addMember("seqName", "$S", new Object[]{seqName});
        }
        return builder.build();
    }

    boolean isAuto(String seqName, boolean isPrimaryId) {
        return "auto".equals(seqName) || "".equals(seqName) && isPrimaryId;
    }

    private MethodSpec m_findPk(TableField primary) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"findPk").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Serializable.class);
        builder.addStatement("return this.$L", new Object[]{primary.getName()});
        return builder.build();
    }

    private void addSuperInterface(TypeSpec.Builder builder, List<Class> interfaces) {
        if (interfaces == null || interfaces.size() == 0) {
            return;
        }
        for (Class _interface : interfaces) {
            if (this.hasEntityType(_interface.getSimpleName(), _interface.getTypeParameters())) {
                builder.addSuperinterface(this.parameterizedType(ClassName.get((Class)_interface), new TypeName[]{this.className()}));
                continue;
            }
            builder.addSuperinterface((Type)_interface);
        }
    }

    private boolean hasEntityType(String interfaceName, TypeVariable[] typeVariables) {
        if (typeVariables.length != 1) {
            return false;
        }
        for (Type bound : typeVariables[0].getBounds()) {
            String tn = bound.getTypeName();
            if (!Objects.equals(tn, interfaceName) && !Allow_Entity_Bounds.contains(tn)) continue;
            return true;
        }
        return false;
    }

    private AnnotationSpec fluentMybatisAnnotation() {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassNames.FM_FluentMybatis);
        builder.addMember("table", "$S", new Object[]{this.table.getTableName()});
        if (!GeneratorHelper.isBlank(this.table.getMapperBeanPrefix())) {
            builder.addMember("mapperBeanPrefix", "$S", new Object[]{this.table.getMapperBeanPrefix()});
        }
        if (this.table.getDefaults() != null) {
            builder.addMember("defaults", "$T.class", new Object[]{this.table.getDefaults()});
        }
        if (this.table.getSuperMapper() != null) {
            builder.addMember("superMapper", "$T.class", new Object[]{this.table.getSuperMapper()});
        }
        if (!Objects.equals(this.table.getEntitySuffix(), "Entity")) {
            builder.addMember("suffix", "$S", new Object[]{this.table.getEntitySuffix()});
        }
        if (DbTypeOfGenerator.MYSQL != this.table.getGlobalConfig().getDbType()) {
            builder.addMember("dbType", "$T.$L", new Object[]{ClassNames.FM_FluentDbType, this.table.getGlobalConfig().getDbType().name()});
        }
        return builder.build();
    }

    @Override
    protected boolean isInterface() {
        return false;
    }

    static {
        Allow_Entity_Bounds.add("cn.org.atool.fluent.mybatis.base.IEntity");
        Allow_Entity_Bounds.add(Object.class.getName());
        Allow_Entity_Bounds.add(Serializable.class.getName());
    }
}

