/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.util;

import cn.org.atool.generator.util.GeneratorHelper;
import java.sql.Connection;
import java.util.Collection;
import java.util.Objects;
import java.util.logging.Level;
import javax.sql.DataSource;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionInclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.tools.utility.SchemaCrawlerUtility;
import us.fatehi.utility.LoggingConfig;

public class SchemaKits {
    private static final String SCHEMA_NOT_FOUND = "Unable to parse schemaName from URL, please specify it explicitly: @Tables(schema=\"yourSchema\")";

    public static String getSchemaName(String schemaName, DataSource dataSource) {
        if (!GeneratorHelper.isBlank(schemaName)) {
            return schemaName;
        }
        try {
            String schema = dataSource.getConnection().getSchema();
            if (GeneratorHelper.isBlank(schema)) {
                schema = dataSource.getConnection().getCatalog();
            }
            if (!GeneratorHelper.isBlank(schema)) {
                return schema;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(SCHEMA_NOT_FOUND, e);
        }
        throw new RuntimeException(SCHEMA_NOT_FOUND);
    }

    public static String getSchemaName(String schemaName, String url) {
        if (!GeneratorHelper.isBlank(schemaName)) {
            return schemaName;
        }
        if (GeneratorHelper.isBlank(url)) {
            throw new RuntimeException(SCHEMA_NOT_FOUND);
        }
        String _url = url;
        int index = url.indexOf(63);
        if (index == -1) {
            index = url.indexOf(59);
        }
        if (index > 0) {
            _url = url.substring(0, index);
        }
        int first = _url.indexOf(47);
        int last = _url.lastIndexOf(47);
        if (last - first > 3 && last + 1 < _url.length()) {
            return _url.substring(last + 1);
        }
        throw new RuntimeException(SCHEMA_NOT_FOUND);
    }

    public static Collection<Table> getTables(Connection connection, String schemaName) {
        new LoggingConfig(Level.OFF);
        try {
            LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSchemas((InclusionRule)new RegularExpressionInclusionRule(".?" + schemaName + ".?")).tableTypes("TABLE");
            LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().withSchemaInfoLevel(SchemaInfoLevelBuilder.standard());
            SchemaCrawlerOptions options = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withLoadOptions(loadOptionsBuilder.toOptions());
            Catalog catalog = SchemaCrawlerUtility.getCatalog((Connection)connection, (SchemaCrawlerOptions)options);
            for (Schema schema : catalog.getSchemas()) {
                String fullName = schema.getFullName();
                if (!SchemaKits.isSchema(fullName, schemaName)) continue;
                return catalog.getTables(schema);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("getTables from schema[" + schemaName + "] error:" + e.getMessage(), e);
        }
        throw new RuntimeException("schema[" + schemaName + "] not found.");
    }

    static boolean isSchema(String fullName, String schemaName) {
        if (Objects.equals(fullName, schemaName)) {
            return true;
        }
        int len = fullName.length();
        char first = fullName.charAt(0);
        char last = fullName.charAt(len - 1);
        return !SchemaKits.isLetterOrDigit(first) && !SchemaKits.isLetterOrDigit(last) && Objects.equals(fullName.substring(1, len - 1), schemaName);
    }

    static boolean isLetterOrDigit(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_';
    }
}

