/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielwegener.logback.kafka.keying;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAwareBase;
import com.github.danielwegener.logback.kafka.keying.KeyingStrategy;
import java.nio.ByteBuffer;

public class HostNameKeyingStrategy
extends ContextAwareBase
implements KeyingStrategy<Object> {
    private byte[] hostnameHash = null;

    public void setContext(Context context) {
        super.setContext(context);
        String hostname = context.getProperty("HOSTNAME");
        if (hostname == null) {
            this.addError("Hostname could not be found in context. HostNamePartitioningStrategy will not work.");
        } else {
            this.hostnameHash = ByteBuffer.allocate(4).putInt(hostname.hashCode()).array();
        }
    }

    @Override
    public byte[] createKey(Object e) {
        return this.hostnameHash;
    }
}

