/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.lists;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.lists.LLen;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.SliceParser;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

abstract class BPop
extends AbstractRedisOperation {
    private final Object lock;

    BPop(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.lock = state.lock();
    }

    abstract AbstractRedisOperation popper(List<Slice> var1);

    @Override
    protected Slice response() {
        int size = this.params().size();
        if (size < 2) {
            throw new IndexOutOfBoundsException("require at least 2 params");
        }
        List<Slice> keys = this.params().subList(0, size - 1);
        long timeout = Utils.convertToLong(this.params().get(size - 1).toString());
        Slice source = this.getKey(keys);
        long waitEnd = System.nanoTime() + timeout * 1000000000L;
        try {
            long waitTime;
            while (source == null && (waitTime = (waitEnd - System.nanoTime()) / 1000000L) > 0L) {
                this.lock.wait(waitTime);
                source = this.getKey(keys);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Response.NULL;
        }
        if (source != null) {
            Slice result = this.popper(Collections.singletonList(source)).execute();
            return Response.array(Arrays.asList(Response.bulkString(source), result));
        }
        System.out.println("Source is still null");
        return Response.NULL;
    }

    private Slice getKey(List<Slice> list) {
        for (Slice key : list) {
            Slice result = new LLen(this.base(), Collections.singletonList(key)).execute();
            int length = SliceParser.consumeInteger(result.data());
            if (length <= 0) continue;
            return key;
        }
        return null;
    }
}

