/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.server;

import com.github.fppt.jedismock.operations.server.MockExecutor;
import com.github.fppt.jedismock.server.RedisCommandInterceptor;
import java.util.concurrent.atomic.AtomicInteger;

public class ServiceOptions {
    private final RedisCommandInterceptor commandInterceptor;

    private ServiceOptions(RedisCommandInterceptor commandInterceptor) {
        this.commandInterceptor = commandInterceptor;
    }

    public RedisCommandInterceptor getCommandInterceptor() {
        return this.commandInterceptor;
    }

    public static ServiceOptions defaultOptions() {
        return new ServiceOptions(MockExecutor::proceed);
    }

    public static ServiceOptions executeOnly(int n) {
        AtomicInteger count = new AtomicInteger();
        return new ServiceOptions((state, name, params) -> {
            if (count.incrementAndGet() > n) {
                return MockExecutor.breakConnection(state);
            }
            return MockExecutor.proceed(state, name, params);
        });
    }

    public static ServiceOptions withInterceptor(RedisCommandInterceptor commandInterceptor) {
        return new ServiceOptions(commandInterceptor);
    }
}

