/*
 * Decompiled with CFR 0.152.
 */
package lzma.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lzma.sdk.lzma.Decoder;
import org.cservenak.streams.Coder;

public class LzmaDecoderWrapper
implements Coder {
    private final Decoder decoder;

    public LzmaDecoderWrapper(Decoder decoder) {
        this.decoder = decoder;
    }

    @Override
    public void code(InputStream in, OutputStream out) throws IOException {
        byte[] properties = new byte[5];
        if (in.read(properties) != 5) {
            throw new IOException("LZMA file has no header!");
        }
        if (!this.decoder.setDecoderProperties(properties)) {
            throw new IOException("Decoder properties cannot be set!");
        }
        long outSize = 0L;
        for (int i = 0; i < 8; ++i) {
            int v = in.read();
            if (v < 0) {
                throw new IOException("Can't read stream size");
            }
            outSize |= (long)v << 8 * i;
        }
        if (!this.decoder.code(in, out, outSize)) {
            throw new IOException("Decoding unsuccessful!");
        }
    }
}

