/*
 * Decompiled with CFR 0.152.
 */
package org.cservenak.streams;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.cservenak.streams.Coder;

public class CoderThread
extends Thread {
    private final PipedInputStream inSink;
    private final PipedOutputStream outSink;
    private final Runnable workhorse;
    private Throwable throwable;

    public CoderThread(final Coder coder, final InputStream in) throws IOException {
        this.inSink = new PipedInputStream();
        this.outSink = new PipedOutputStream(this.inSink);
        this.workhorse = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    coder.code(in, CoderThread.this.outSink);
                    CoderThread.this.flush(CoderThread.this.outSink);
                }
                catch (Throwable e) {
                    CoderThread.this.throwable = e;
                }
                finally {
                    CoderThread.this.close(CoderThread.this.outSink);
                }
            }
        };
    }

    public CoderThread(final Coder coder, final OutputStream out) throws IOException {
        this.outSink = new PipedOutputStream();
        this.inSink = new PipedInputStream(this.outSink);
        this.workhorse = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    coder.code(CoderThread.this.inSink, out);
                    CoderThread.this.flush(out);
                }
                catch (Throwable e) {
                    CoderThread.this.throwable = e;
                }
                finally {
                    CoderThread.this.close(CoderThread.this.inSink);
                }
            }
        };
    }

    @Override
    public void run() {
        this.workhorse.run();
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void checkForException() throws IOException {
        if (null != this.throwable) {
            if (this.throwable instanceof IOException) {
                throw (IOException)this.throwable;
            }
            throw new IOException(this.throwable);
        }
    }

    public PipedInputStream getInputStreamSink() {
        return this.inSink;
    }

    public PipedOutputStream getOutputStreamSink() {
        return this.outSink;
    }

    protected boolean flush(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

