/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.MACAddressStringParameters;
import inet.ipaddr.format.validate.ParsedMACAddress;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressNetwork;
import inet.ipaddr.mac.MACAddressSection;
import inet.ipaddr.mac.MACAddressSegment;
import java.io.Serializable;
import java.util.Arrays;

public class MACAddressProvider
implements Serializable {
    private static final long serialVersionUID = 4L;
    private ParsedMACAddress parsedAddress;
    private MACAddress address;
    static final MACAddressProvider EMPTY_PROVIDER = new MACAddressProvider(){

        @Override
        public MACAddress getAddress() {
            return null;
        }
    };

    private MACAddressProvider() {
    }

    public MACAddressProvider(ParsedMACAddress parsedAddress) {
        this.parsedAddress = parsedAddress;
    }

    public MACAddressProvider(MACAddress address) {
        this.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MACAddress getAddress() {
        if (this.parsedAddress != null) {
            MACAddressProvider mACAddressProvider = this;
            synchronized (mACAddressProvider) {
                if (this.parsedAddress != null) {
                    this.address = this.parsedAddress.createAddress();
                    this.parsedAddress = null;
                }
            }
        }
        return this.address;
    }

    public static MACAddressProvider getAllProvider(MACAddressStringParameters validationOptions) {
        MACAddressNetwork network = validationOptions.getNetwork();
        MACAddressStringParameters.AddressSize allAddresses = validationOptions.addressSize;
        final MACAddressNetwork.MACAddressCreator creator = network.getAddressCreator();
        MACAddressSegment allRangeSegment = creator.createRangeSegment(0, 255);
        Object[] segments = creator.createSegmentArray(allAddresses == MACAddressStringParameters.AddressSize.EUI64 ? 8 : 6);
        Arrays.fill(segments, allRangeSegment);
        return new MACAddressProvider((MACAddressSegment[])segments){
            private static final long serialVersionUID = 4L;
            private final /* synthetic */ MACAddressSegment[] val$segments;
            {
                this.val$segments = mACAddressSegmentArray;
                super((MACAddressProvider)null);
            }

            @Override
            public MACAddress getAddress() {
                MACAddressNetwork.MACAddressCreator parsedCreator = creator;
                MACAddressSection section = (MACAddressSection)parsedCreator.createSectionInternal(this.val$segments);
                return creator.createAddress(section);
            }
        };
    }

    public String toString() {
        return String.valueOf(this.getAddress());
    }

    /* synthetic */ MACAddressProvider(MACAddressProvider mACAddressProvider) {
        this();
    }
}

