/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.model;

import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.TagDoc;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class DocMapping {
    public static final Map<String, TagDoc> TAG_DOC = new ConcurrentHashMap<String, TagDoc>(64);
    public static final Set<ApiDoc> CLAZZ_DOCS = Collections.synchronizedSet(new LinkedHashSet(64));
    public static final Set<ApiMethodDoc> METHOD_DOCS = Collections.synchronizedSet(new LinkedHashSet(1024));

    public static void tagDocPut(String tag, ApiDoc apiDoc, ApiMethodDoc methodDoc) {
        if (StringUtils.isBlank((CharSequence)tag)) {
            return;
        }
        TagDoc tagDoc = TAG_DOC.computeIfAbsent(tag, TagDoc::new);
        if (Objects.nonNull(apiDoc)) {
            apiDoc.getTagRefs().add(tagDoc);
            tagDoc.getClazzDocs().add(apiDoc);
            CLAZZ_DOCS.add(apiDoc);
        }
        if (Objects.nonNull(methodDoc)) {
            methodDoc.getTagRefs().add(tagDoc);
            tagDoc.getMethodDocs().add(methodDoc);
            METHOD_DOCS.add(methodDoc);
        }
    }
}

