/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import jetbrick.asm.ClassReader;
import jetbrick.asm.ClassVisitor;
import jetbrick.asm.Label;
import jetbrick.asm.MethodVisitor;
import jetbrick.bean.Executable;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.MethodInfo;
import jetbrick.bean.TypeResolverUtils;
import jetbrick.util.ClassLoaderUtils;

public final class ParameterInfo {
    private final Executable declaringExecutable;
    private final Class<?> type;
    private final Type genericType;
    private final Annotation[] annotations;
    private final int offset;
    private String name;

    protected ParameterInfo(Executable declaringExecutable, Class<?> type, Type genericType, Annotation[] annotations, int offset) {
        this.declaringExecutable = declaringExecutable;
        this.type = type;
        this.genericType = genericType;
        this.annotations = annotations;
        this.offset = offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null) {
            KlassInfo declaringklass;
            KlassInfo klassInfo = declaringklass = this.declaringExecutable.getDeclaringKlass();
            synchronized (klassInfo) {
                ParameterInfo.receiveParameterNames(declaringklass);
                if (this.name == null) {
                    this.name = "arg".concat(String.valueOf(this.offset));
                }
            }
        }
        return this.name;
    }

    public Executable getDeclaringExecutable() {
        return this.declaringExecutable;
    }

    public int getOffset() {
        return this.offset;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public Class<?> getRawType(KlassInfo declaringKlass) {
        return this.getRawType(declaringKlass.getType());
    }

    public Class<?> getRawType(Class<?> declaringClass) {
        return TypeResolverUtils.getRawType(this.genericType, declaringClass);
    }

    public Class<?> getRawComponentType(Class<?> declaringClass, int componentIndex) {
        return TypeResolverUtils.getComponentType(this.genericType, declaringClass, componentIndex);
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Annotation annotation : this.annotations) {
            if (annotationClass != annotation.annotationType()) continue;
            return (T)annotation;
        }
        return null;
    }

    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public String toString() {
        return this.type.getName() + " " + (this.name == null ? "arg" + String.valueOf(this.offset) : this.name);
    }

    private static void receiveParameterNames(final KlassInfo declaringklass) {
        if (declaringklass.getType().getClassLoader() == null) {
            return;
        }
        ClassReader cr = null;
        try {
            InputStream stream = ClassLoaderUtils.getClassAsStream(declaringklass.getType());
            cr = new ClassReader(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        cr.accept(new ClassVisitor(327680){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                final MethodInfo method = this.searchMethod(declaringklass, name, desc);
                if (method == null) {
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new MethodVisitor(327680, mv){
                    List<ParameterInfo> parameters;
                    boolean isStatic;
                    int visitParameterIndex;
                    {
                        super(api, mv);
                        this.parameters = method.getParameters();
                        this.isStatic = method.isStatic();
                        this.visitParameterIndex = 0;
                    }

                    @Override
                    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                        int offset;
                        int n = offset = this.isStatic ? index : index - 1;
                        if (offset >= 0 && offset < this.parameters.size()) {
                            this.parameters.get(offset).name = name;
                        }
                        super.visitLocalVariable(name, desc, signature, start, end, index);
                    }

                    @Override
                    public void visitParameter(String name, int access) {
                        this.parameters.get(this.visitParameterIndex++).name = name;
                        super.visitParameter(name, access);
                    }
                };
            }

            private MethodInfo searchMethod(KlassInfo declaringklass2, String name, String desc) {
                if ("<cinit>".equals(name)) {
                    return null;
                }
                if ("<init>".equals(name)) {
                    return null;
                }
                jetbrick.asm.Type[] argumentTypes = jetbrick.asm.Type.getArgumentTypes(desc);
                for (MethodInfo method : declaringklass2.getDeclaredMethods()) {
                    if (!method.getName().equals(name) || argumentTypes.length != method.getParameterCount()) continue;
                    Class<?>[] types = method.getParameterTypes();
                    boolean matched = true;
                    for (int i = 0; i < argumentTypes.length; ++i) {
                        if (jetbrick.asm.Type.getType(types[i]).equals(argumentTypes[i])) continue;
                        matched = false;
                        break;
                    }
                    if (!matched) continue;
                    return method;
                }
                return null;
            }
        }, 4);
    }
}

