/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.collection.multimap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrick.collection.multimap.MultiValueMap;

public abstract class AbstractMultiValueMap<K, V>
implements MultiValueMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<K, List<V>> map;

    protected AbstractMultiValueMap(Map<K, List<V>> map) {
        this.map = map;
    }

    @Override
    public int size() {
        int total = 0;
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            total += entry.getValue().size();
        }
        return total;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            if (!entry.getValue().contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        List<V> values = this.map.get(key);
        return values != null ? (V)values.get(0) : null;
    }

    @Override
    public V put(K key, V value) {
        List<V> values = this.map.get(key);
        if (values == null) {
            values = new ArrayList<V>();
            this.map.put(key, values);
        }
        values.add(value);
        return null;
    }

    @Override
    public V remove(Object key) {
        this.map.remove(key);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList(this.map.size() * 3);
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            values.addAll(entry.getValue());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entrys = new HashSet<Map.Entry<K, V>>(this.map.size() * 3);
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            final K key = entry.getKey();
            for (final V value : entry.getValue()) {
                entrys.add(new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return key;
                    }

                    @Override
                    public V getValue() {
                        return value;
                    }

                    @Override
                    public V setValue(V value2) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
        }
        return entrys;
    }

    @Override
    public boolean containsValue(Object key, Object value) {
        List<V> values = this.map.get(key);
        return values == null ? false : values.contains(value);
    }

    @Override
    public Collection<List<V>> valuesList() {
        return this.map.values();
    }

    @Override
    public List<V> getList(Object key) {
        return this.map.get(key);
    }

    @Override
    public Set<Map.Entry<K, List<V>>> multiEntrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this == o || this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

