/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

import java.text.DateFormatSymbols;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import jetbrick.util.StringUtils;

public final class LocaleUtils {
    private static Map<String, LocaleInfo> locales = new HashMap<String, LocaleInfo>();

    public static Locale getLocale(String language, String country, String variant) {
        LocaleInfo info = LocaleUtils.lookupLocaleInfo(LocaleUtils.resolveLocaleCode(language, country, variant));
        return info.locale;
    }

    public static Locale getLocale(String language, String country) {
        return LocaleUtils.getLocale(language, country, null);
    }

    public static Locale getLocale(String languageCode) {
        LocaleInfo info = LocaleUtils.lookupLocaleInfo(languageCode);
        return info.locale;
    }

    public static String resolveLocaleCode(String lang, String country, String variant) {
        StringBuilder code = new StringBuilder(lang);
        if (country != null && country.length() > 0) {
            code.append('_').append(country);
            if (variant != null && variant.length() > 0) {
                code.append('_').append(variant);
            }
        }
        return code.toString();
    }

    public static String resolveLocaleCode(Locale locale) {
        return LocaleUtils.resolveLocaleCode(locale.getLanguage(), locale.getCountry(), locale.getVariant());
    }

    public static String[] decodeLocaleCode(String localeCode) {
        String[] data = StringUtils.split(localeCode, '_');
        String[] result = new String[]{data[0], "", ""};
        if (data.length >= 2) {
            result[1] = data[1];
            if (data.length >= 3) {
                result[2] = data[2];
            }
        }
        return result;
    }

    public static DateFormatSymbols getDateFormatSymbols(Locale locale) {
        LocaleInfo info = LocaleUtils.lookupLocaleInfo(locale);
        DateFormatSymbols dfs = info.dateFormatSymbols;
        if (dfs == null) {
            info.dateFormatSymbols = dfs = new DateFormatSymbols(locale);
        }
        return dfs;
    }

    public static NumberFormat getNumberFormat(Locale locale) {
        LocaleInfo info = LocaleUtils.lookupLocaleInfo(locale);
        NumberFormat nf = info.numberFormat;
        if (nf == null) {
            info.numberFormat = nf = NumberFormat.getInstance(locale);
        }
        return nf;
    }

    protected static LocaleInfo lookupLocaleInfo(String code) {
        LocaleInfo info = locales.get(code);
        if (info == null) {
            String[] data = LocaleUtils.decodeLocaleCode(code);
            info = new LocaleInfo(new Locale(data[0], data[1], data[2]));
            locales.put(code, info);
        }
        return info;
    }

    protected static LocaleInfo lookupLocaleInfo(Locale locale) {
        return LocaleUtils.lookupLocaleInfo(LocaleUtils.resolveLocaleCode(locale));
    }

    private static class LocaleInfo {
        final Locale locale;
        DateFormatSymbols dateFormatSymbols;
        NumberFormat numberFormat;

        LocaleInfo(Locale locale) {
            this.locale = locale;
        }
    }
}

