/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.util;

import java.security.CodeSource;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VersionUtils {
    private static final String DEFAULT_VERSION = "1.0.0";

    public static String getVersion(Class<?> cls) {
        return VersionUtils.getVersion(cls, DEFAULT_VERSION);
    }

    public static String getVersion(Class<?> cls, String defaultVersion) {
        try {
            Matcher matcher;
            String file;
            CodeSource codeSource;
            String version = cls.getPackage().getImplementationVersion();
            if (version == null || version.length() == 0) {
                version = cls.getPackage().getSpecificationVersion();
            }
            if ((version == null || version.length() == 0) && (codeSource = cls.getProtectionDomain().getCodeSource()) != null && (file = codeSource.getLocation().getFile()) != null && (matcher = Pattern.compile("[\\-\\._][vV]?(\\d+([\\-\\._]\\d+)*)\\.jar$").matcher(file)).find()) {
                version = matcher.group(1);
                version = version.replaceAll("[\\-_]", ".");
            }
            if (version == null || version.length() == 0) {
                version = defaultVersion;
            }
            return version;
        }
        catch (Exception e) {
            return defaultVersion;
        }
    }
}

