/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public final class ListUtils {
    public static <T> List<T> asList(T[] items) {
        if (items == null) {
            return null;
        }
        return Arrays.asList(items);
    }

    public static <T> List<T> asList(Collection<T> items) {
        if (items == null) {
            return null;
        }
        if (items instanceof List) {
            return (List)items;
        }
        return new ArrayList<T>(items);
    }

    public static <T> List<T> asList(Iterator<T> items) {
        if (items == null) {
            return null;
        }
        ArrayList<T> results = new ArrayList<T>();
        while (items.hasNext()) {
            results.add(items.next());
        }
        return results;
    }

    public static <T> List<T> asList(Iterable<T> items) {
        if (items == null) {
            return null;
        }
        if (items instanceof List) {
            return (List)items;
        }
        if (items instanceof Collection) {
            return new ArrayList((Collection)items);
        }
        return ListUtils.asList(items.iterator());
    }

    public static <T> List<T> asList(Enumeration<T> items) {
        if (items == null) {
            return null;
        }
        ArrayList<T> results = new ArrayList<T>();
        while (items.hasMoreElements()) {
            results.add(items.nextElement());
        }
        return results;
    }

    public static <T> T[] asArray(Collection<T> items, Class<T> elementType) {
        if (items == null) {
            return null;
        }
        Object[] results = (Object[])Array.newInstance(elementType, items.size());
        int i = 0;
        for (T item : items) {
            results[i++] = item;
        }
        return results;
    }

    public static <T> T[] asArray(Iterator<T> items, Class<T> elementType) {
        if (items == null) {
            return null;
        }
        return ListUtils.asArray(ListUtils.asList(items), elementType);
    }

    public static <T> T[] asArray(Iterable<T> items, Class<T> elementType) {
        if (items == null) {
            return null;
        }
        if (items instanceof Collection) {
            return ListUtils.asArray((Collection)items, elementType);
        }
        return ListUtils.asArray(ListUtils.asList(items.iterator()), elementType);
    }

    public static <T> T[] asArray(Enumeration<T> items, Class<T> elementType) {
        if (items == null) {
            return null;
        }
        return ListUtils.asArray(ListUtils.asList(items), elementType);
    }
}

