/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.config;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Properties;
import jetbrick.config.EmptyProperties;
import jetbrick.io.IoUtils;
import jetbrick.util.CharsetUtils;
import jetbrick.util.StringEscapeUtils;

final class ExtendPropertiesLoader {
    private static final Charset DEFAULT_CHARSET = CharsetUtils.UTF_8;

    ExtendPropertiesLoader() {
    }

    public static Properties load(InputStream is) {
        return ExtendPropertiesLoader.load(is, DEFAULT_CHARSET);
    }

    public static Properties load(InputStream is, Charset charset) {
        if (is == null) {
            return EmptyProperties.INSTANCE;
        }
        if (charset == null) {
            charset = DEFAULT_CHARSET;
        }
        return ExtendPropertiesLoader.load(new BufferedReader(new InputStreamReader(is, charset)));
    }

    public static Properties load(BufferedReader reader) {
        Properties props = new Properties();
        String line = null;
        String key = null;
        try {
            while ((line = reader.readLine()) != null) {
                StringBuilder sb;
                String value;
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    key = line.substring(1, line.length() - 1).trim();
                    continue;
                }
                int pos = line.indexOf(61);
                if (pos <= 0) continue;
                String name = line.substring(0, pos).trim();
                if (key != null && key.length() > 0) {
                    name = "@".equals(name) ? key : key + '.' + name;
                }
                if ((value = line.substring(pos + 1).trim()).startsWith("'''")) {
                    if (value.length() >= 6 && value.endsWith("'''")) {
                        props.put(name, value.substring(3, value.length() - 3));
                        continue;
                    }
                    sb = new StringBuilder();
                    sb.append(value, 3, value.length()).append('\n');
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).endsWith("'''")) {
                            sb.append(line, 0, line.length() - 3);
                            break;
                        }
                        sb.append(line).append('\n');
                    }
                    props.put(name, sb.toString());
                    continue;
                }
                if (value.endsWith("\\") && !value.endsWith("\\\\")) {
                    sb = new StringBuilder();
                    sb.append(value, 0, value.length() - 1);
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).startsWith("#")) continue;
                        if (line.endsWith("\\") && !line.endsWith("\\\\")) {
                            sb.append(line, 0, line.length() - 1);
                            continue;
                        }
                        sb.append(line);
                        break;
                    }
                    props.put(name, StringEscapeUtils.unescapeJava(sb.toString()));
                    continue;
                }
                props.put(name, StringEscapeUtils.unescapeJava(value));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IoUtils.closeQuietly(reader);
        }
        return props;
    }
}

