/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;

public final class CharacterConvertor
implements Convertor<Character> {
    public static final CharacterConvertor INSTANCE = new CharacterConvertor();

    @Override
    public Character convert(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 1) {
            return Character.valueOf(value.charAt(0));
        }
        try {
            char c = (char)Integer.parseInt(value, 10);
            return Character.valueOf(c);
        }
        catch (NumberFormatException e) {
            throw TypeCastException.create(value, Character.class, e);
        }
        catch (IndexOutOfBoundsException e) {
            throw TypeCastException.create(value, Character.class, e);
        }
    }

    @Override
    public Character convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Character.class) {
            return (Character)value;
        }
        if (value instanceof Number) {
            char c = (char)((Number)value).intValue();
            return Character.valueOf(c);
        }
        return this.convert(value.toString());
    }
}

