/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;
import jetbrick.util.ClassLoaderUtils;

public final class ClassConvertor
implements Convertor<Class<?>> {
    public static final ClassConvertor INSTANCE = new ClassConvertor();

    @Override
    public Class<?> convert(String value) {
        if (value == null) {
            return null;
        }
        try {
            return ClassLoaderUtils.loadClassEx(value);
        }
        catch (ClassNotFoundException e) {
            throw TypeCastException.create(value, Class.class, e);
        }
    }

    @Override
    public Class<?> convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Class.class) {
            return (Class)value;
        }
        return this.convert(value.toString());
    }
}

