/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.web.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import jetbrick.io.stream.UnsafeByteArrayOutputStream;
import jetbrick.io.stream.UnsafeCharArrayWriter;
import jetbrick.util.ArrayUtils;

public final class BufferedHttpServletResponse
extends HttpServletResponseWrapper {
    private UnsafeByteArrayOutputStream originStream;
    private ServletOutputStream stream;
    private UnsafeCharArrayWriter originWriter;
    private PrintWriter writer;

    public BufferedHttpServletResponse(HttpServletResponse response) {
        super(response);
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            throw new IllegalStateException("the getOutputStream method has already been called for this response object");
        }
        this.originWriter = new UnsafeCharArrayWriter();
        this.writer = new PrintWriter(this.originWriter);
        return this.writer;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.stream != null) {
            return this.stream;
        }
        if (this.writer != null) {
            throw new IllegalStateException("the getWriter method has already been called for this response object");
        }
        this.originStream = new UnsafeByteArrayOutputStream();
        this.stream = new ServletOutputStream(){

            public void write(int b) throws IOException {
                BufferedHttpServletResponse.this.originStream.write(b);
            }
        };
        return this.stream;
    }

    public byte[] toByteArray() {
        if (this.originStream != null) {
            return this.originStream.toByteArray();
        }
        if (this.originWriter != null) {
            try {
                return this.originWriter.toString().getBytes(this.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return ArrayUtils.EMPTY_BYTE_ARRAY;
    }

    public char[] toCharArray() {
        if (this.originWriter != null) {
            return this.originWriter.toCharArray();
        }
        if (this.originStream != null) {
            try {
                return this.originStream.toString(this.getCharacterEncoding()).toCharArray();
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return ArrayUtils.EMPTY_CHAR_ARRAY;
    }

    public String toString() {
        if (this.originWriter != null) {
            return this.originWriter.toString();
        }
        if (this.originStream != null) {
            try {
                return this.originStream.toString(this.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return "";
    }
}

