/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.web.servlet.map;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import jetbrick.util.concurrent.ConcurrentInitializer;
import jetbrick.util.concurrent.LazyInitializer;

public final class RequestCookieMap
implements Map<String, Cookie> {
    private final HttpServletRequest request;
    private final ConcurrentInitializer<Map<String, Cookie>> map = new LazyInitializer<Map<String, Cookie>>(){

        @Override
        protected Map<String, Cookie> initialize() {
            Cookie[] cookies = RequestCookieMap.this.request.getCookies();
            if (cookies == null) {
                return Collections.emptyMap();
            }
            HashMap<String, Cookie> map = new HashMap<String, Cookie>();
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                map.put(name, cookie);
            }
            return map;
        }
    };

    public RequestCookieMap(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.get().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.get().containsValue(value);
    }

    @Override
    public Cookie get(Object key) {
        return this.map.get().get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.get().isEmpty();
    }

    @Override
    public int size() {
        return this.map.get().size();
    }

    @Override
    public Set<Map.Entry<String, Cookie>> entrySet() {
        return this.map.get().entrySet();
    }

    @Override
    public Set<String> keySet() {
        return this.map.get().keySet();
    }

    @Override
    public Collection<Cookie> values() {
        return this.map.get().values();
    }

    @Override
    public synchronized Cookie put(String key, Cookie value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void putAll(Map<? extends String, ? extends Cookie> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Cookie remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void clear() {
        throw new UnsupportedOperationException();
    }
}

