/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CompositeIndexManager;
import com.google.apphosting.api.AppEngineInternal;
import com.google.storage.onestore.v3.OnestoreEntity;

@AppEngineInternal
public final class CompositeIndexUtils {
    private static final String DATASTORE_INDEX_WITH_PROPERTIES_XML_FORMAT = "    <datastore-index kind=\"%s\" %s source=\"%s\">\n%s    </datastore-index>\n\n";
    private static final String ANCESTOR_ATTRIBUTE_FORMAT = "ancestor=\"%s\"";
    private static final String DATASTORE_INDEX_NO_PROPERTIES_XML_FORMAT = "    <datastore-index kind=\"%s\" ancestor=\"%s\" source=\"%s\"/>\n\n";
    private static final String PROPERTY_XML_FORMAT = "        <property name=\"%s\" %s/>\n";
    private static final String ASC_ATTRIBUTE = "direction=\"asc\"";
    private static final String DESC_ATTRIBUTE = "direction=\"desc\"";
    private static final String GEOSPATIAL_ATTRIBUTE = "mode=\"geospatial\"";

    private CompositeIndexUtils() {
    }

    public static String generateXmlForIndex(OnestoreEntity.Index index, CompositeIndexManager.IndexSource source) {
        boolean isAncestor = index.isAncestor();
        if (index.propertySize() == 0) {
            return String.format(DATASTORE_INDEX_NO_PROPERTIES_XML_FORMAT, new Object[]{index.getEntityType(), isAncestor, source});
        }
        boolean isSearchIndex = false;
        StringBuilder sb = new StringBuilder();
        for (OnestoreEntity.Index.Property prop : index.propertys()) {
            String extraAttribute;
            if (prop.getDirectionEnum() == OnestoreEntity.Index.Property.Direction.ASCENDING) {
                extraAttribute = ASC_ATTRIBUTE;
            } else if (prop.getDirectionEnum() == OnestoreEntity.Index.Property.Direction.DESCENDING) {
                extraAttribute = DESC_ATTRIBUTE;
            } else if (prop.getModeEnum() == OnestoreEntity.Index.Property.Mode.GEOSPATIAL) {
                isSearchIndex = true;
                extraAttribute = GEOSPATIAL_ATTRIBUTE;
            } else {
                extraAttribute = "";
            }
            sb.append(String.format(PROPERTY_XML_FORMAT, prop.getName(), extraAttribute));
        }
        String ancestorAttribute = isSearchIndex ? "" : String.format(ANCESTOR_ATTRIBUTE_FORMAT, isAncestor);
        return String.format(DATASTORE_INDEX_WITH_PROPERTIES_XML_FORMAT, new Object[]{index.getEntityType(), ancestorAttribute, source, sb.toString()});
    }
}

